from sqlalchemy import Column, Integer, String, DateTime

from model.entity.BaseEntity import BaseEntity


class AiChatRecommendQuestionEntity(BaseEntity):
    __tablename__ = "t_ai_chat_recommend_question"
    customer_id = Column(Integer)
    question = Column(String)
    question_type = Column(String)
    """fixed：固定问题 mcp：需要调用mcp服务的问题"""

    default_answer = Column(String)
    """部分长期不会发生改变的问题默认回答"""

    latest_answer_time = Column(DateTime)
    """默认回答最近一次更新时间"""

    answer_update_frequency = Column(Integer)
    """默认回答的更新频率，单位为天，比如30，则表示每30天更新一次默认回答"""