import sys

from loguru import logger

from config.system import config


def configure_logger():
    # 移除默认的配置（避免重复输出）
    logger.remove()

    # 定义日志格式
    fmt = (
        "<green>{time:YYYY-MM-DD HH:mm:ss.SSS}</green> | "
        "<level>{level: <8}</level> | "
        "<cyan>{name}</cyan>:<cyan>{function}</cyan>:<cyan>{line}</cyan> - "
        "<level>{message}</level>"
    )

    # 添加控制台输出
    logger.add(
        sys.stdout,
        level="INFO",
        format=fmt,
        colorize=True,  # 启用彩色输出
        backtrace=True,  # 记录异常堆栈
        diagnose=True,  # 显示变量值（生产环境建议关闭）
    )

    # 添加文件输出（按时间或大小轮转）
    logger.add(
        config["log"]["base_path"] + "/app_{time:YYYY-MM-DD}.log",
        level="INFO",
        format=fmt,
        rotation="00:00",  # 每天轮转
        retention="30 days",  # 保留30天
        compression="zip",  # 压缩旧日志
        enqueue=True,  # 线程安全
        encoding="utf-8",
    )


# 初始化配置（项目启动时调用一次）
configure_logger()

# 导出全局日志实例
__all__ = ["logger"]
