package com.bme.access.guangdong.service;

import com.alibaba.fastjson.JSON;
import com.bme.access.guangdong.common.HttpUtils;
import com.bme.access.guangdong.dao.EnterpriseInfoMapper;
import com.bme.access.guangdong.model.Enterprise;
import com.bme.access.guangdong.model.EnterpriseInfo;
import com.bme.access.guangdong.model.EnterpriseOriginalInfo;
import com.bme.access.guangdong.model.LoginResult;
import com.bme.access.guangdong.utils.AESPKCS7PaddingUtils;
import lombok.extern.slf4j.Slf4j;
import org.json.JSONObject;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;

@Service
@Slf4j
public class EnterpriseService {

    @Autowired
    private EnterpriseInfoMapper enterpriseInfoMapper;
    @Autowired
    private LoginService loginService;

    private static String host = "http://113.96.111.154:18830";
    private static String url = "/api/qymj/pushCompany";

    public void uploadEnterpriseInfo() {
        // 查询企业信息
        EnterpriseInfo enterpriseInfo;
        EnterpriseOriginalInfo originalInfo = enterpriseInfoMapper.getEnterpriseInfo();
        if (Objects.nonNull(originalInfo)) {
            enterpriseInfo = convertInfo(originalInfo);
            String jsonStr = JSON.toJSONString(enterpriseInfo);
            String sign = getSign(jsonStr);
            // 使用AES密钥进行加密
            Enterprise enterprise = new Enterprise();
            BeanUtils.copyProperties(enterpriseInfo, enterprise);
            enterprise.setSIGN(sign);
            LoginResult loginResult = loginService.login();
            String key = "";
            if (Objects.nonNull(loginResult) && Objects.nonNull(loginResult.getData())) {
                key = loginResult.getData().getAes_secret();
            }
            enterprise.setSIGN(AESPKCS7PaddingUtils.encrypt(enterprise.getSIGN(), key));
            enterprise.setQYBH(AESPKCS7PaddingUtils.encrypt(enterprise.getQYBH(), key));
            enterprise.setQYMC(AESPKCS7PaddingUtils.encrypt(enterprise.getQYMC(), key));
            enterprise.setTYSHXYDM(AESPKCS7PaddingUtils.encrypt(enterprise.getTYSHXYDM(), key));
            enterprise.setXZQHDM(AESPKCS7PaddingUtils.encrypt(enterprise.getXZQHDM(), key));
            enterprise.setQYDZ(AESPKCS7PaddingUtils.encrypt(enterprise.getQYDZ(), key));
            // enterprise.setJD(AESPKCS7PaddingUtils.encrypt(enterprise.getSIGN(), key))
            // enterprise.setWD(AESPKCS7PaddingUtils.encrypt(enterprise.getSIGN(), key))
            enterprise.setFRDB(AESPKCS7PaddingUtils.encrypt(enterprise.getFRDB(), key));
            enterprise.setHYFZ(AESPKCS7PaddingUtils.encrypt(enterprise.getHYFZ(), key));
            enterprise.setJXFJGK(AESPKCS7PaddingUtils.encrypt(enterprise.getJXFJGK(), key));
            enterprise.setLXR(AESPKCS7PaddingUtils.encrypt(enterprise.getLXR(), key));
            enterprise.setLXRDH(AESPKCS7PaddingUtils.encrypt(enterprise.getLXRDH(), key));
            enterprise.setPWXKZBH(AESPKCS7PaddingUtils.encrypt(enterprise.getPWXKZBH(), key));
            enterprise.setPWDJBH(AESPKCS7PaddingUtils.encrypt(enterprise.getPWDJBH(), key));
            String jsonData = JSON.toJSONString(enterprise);
            try {
                HttpUtils.sendPost(host, url, null, jsonData);
            } catch (Exception e) {
                log.info(e.getMessage());
            }
            // String result = HttpUtils.uploadData("qyjbxx", "1.0", cityId, jsonStr, account, password, key);
            // log.info("上传企业基本数据结果：{}", result);
        }
    }

    private String getSign(String jsonStr) {
        org.json.JSONObject jsonObj = new org.json.JSONObject(jsonStr);
        Map<String, Object> sortedMap = new TreeMap<>(jsonObj.toMap()); // 使用TreeMap自动排序键值对
        String sortedJsonStr = new JSONObject(sortedMap).toString(); // 将排序后的Map转换回JSON字符串

        try {
            MessageDigest digest = MessageDigest.getInstance("SHA-256");
            byte[] encodedhash = digest.digest(sortedJsonStr.getBytes()); // 生成哈希值字节数组
            return bytesToHex(encodedhash); // 将字节数组转换为十六进制字符串
        } catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
        }
        return "";
    }

    private static String bytesToHex(byte[] bytes) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < bytes.length; i++) {
            sb.append(String.format("%02x", bytes[i]));
        }
        return sb.toString();
    }

    private EnterpriseInfo convertInfo(EnterpriseOriginalInfo originalInfo) {
        EnterpriseInfo enterpriseInfo = new EnterpriseInfo();
        // 经度
        enterpriseInfo.setJD(originalInfo.getLongitude());
        // 行业分支
        enterpriseInfo.setHYFZ(originalInfo.getIndustryBranch());
        // 法人代表
        enterpriseInfo.setFRDB(originalInfo.getLegalRepresentative());
        // 纬度
        enterpriseInfo.setWD(originalInfo.getLatitude());
        // 联系人
        enterpriseInfo.setLXR(originalInfo.getContacts());
        // 绩效分级管控类型
        enterpriseInfo.setJXFJGK(originalInfo.getPerformanceGradingControlType());
        // 联系人电话
        enterpriseInfo.setLXRDH(originalInfo.getContactPhone());
        // 企业编号
        enterpriseInfo.setQYBH(originalInfo.getEnterpriseId());
        // 企业地址
        enterpriseInfo.setQYDZ(originalInfo.getEnterpriseAddress());
        // 企业名称
        enterpriseInfo.setQYMC(originalInfo.getEnterpriseName());
        // 统一社会信用代码
        enterpriseInfo.setTYSHXYDM(originalInfo.getUnifiedSocialCreditCode());
        // 行政区划代码
        enterpriseInfo.setXZQHDM(originalInfo.getRegionalismCode());
        // 排污许可证编号
        enterpriseInfo.setPWXKZBH(originalInfo.getPollutantDischargePermitNo());
        // 排污登记编号
        enterpriseInfo.setPWDJBH(originalInfo.getPollutantDischargeRegistrationNo());
        return enterpriseInfo;
    }
}
