package com.bme.access.guangdong.service;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.serializer.PascalNameFilter;
import com.bme.access.guangdong.common.HttpUtils;
import com.bme.access.guangdong.dao.EnterpriseInfoMapper;
import com.bme.access.guangdong.model.EnterpriseInfo;
import com.bme.access.guangdong.model.EnterpriseOriginalInfo;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

import java.util.Objects;

@Service
@Slf4j
public class EnterpriseService {

    @Autowired
    private EnterpriseInfoMapper enterpriseInfoMapper;
    @Value("${cityId}")
    private String cityId;
    @Value("${account}")
    private String account;
    @Value("${password}")
    private String password;
    @Value("${key}")
    private String key;
    public void uploadEnterpriseInfo() {
        // 查询企业信息
        EnterpriseInfo enterpriseInfo;
        EnterpriseOriginalInfo originalInfo = enterpriseInfoMapper.getEnterpriseInfo();
        if (Objects.nonNull(originalInfo)) {
            enterpriseInfo = convertInfo(originalInfo);
            String jsonStr = JSON.toJSONString(enterpriseInfo, new PascalNameFilter());
            String result = HttpUtils.uploadData("qyjbxx", "1.0", cityId, jsonStr, account, password, key);
            log.info("上传企业基本数据结果：{}", result);
        }
    }

    private EnterpriseInfo convertInfo(EnterpriseOriginalInfo originalInfo) {
        EnterpriseInfo enterpriseInfo = new EnterpriseInfo();
        enterpriseInfo.setJD(originalInfo.getLongitude());
        enterpriseInfo.setDZSL(originalInfo.getBarriersNumber());
        enterpriseInfo.setHYFZ(originalInfo.getIndustryBranch());
        enterpriseInfo.setFRDB(originalInfo.getLegalRepresentative());
        enterpriseInfo.setHYLX(originalInfo.getIndustryType());
        enterpriseInfo.setCNYSCLSL(originalInfo.getInFactoryVehicleNumber());
        enterpriseInfo.setWD(originalInfo.getLatitude());
        enterpriseInfo.setLXR(originalInfo.getContacts());
        enterpriseInfo.setJXFJGK(originalInfo.getPerformanceGradingControlType());
        enterpriseInfo.setLXRDH(originalInfo.getContactPhone());
        enterpriseInfo.setQYBH(originalInfo.getEnterpriseId());
        enterpriseInfo.setQYDZ(originalInfo.getEnterpriseAddress());
        enterpriseInfo.setQYMC(originalInfo.getEnterpriseName());
        enterpriseInfo.setZHCRKSL(originalInfo.getUnloadingEntrancesNumber());
        enterpriseInfo.setFDLYDJXSL(originalInfo.getNoRoadVehicleNumber());
        enterpriseInfo.setYSCLSL(originalInfo.getTransportVehiclesNumber());
        enterpriseInfo.setTYSHXYDM(originalInfo.getUnifiedSocialCreditCode());
        enterpriseInfo.setXZQHDM(originalInfo.getRegionalismCode());
        return enterpriseInfo;
    }
}
