package com.bme.access.guangdong.job;

import com.bme.access.guangdong.service.*;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.annotation.EnableScheduling;
import org.springframework.stereotype.Component;

import javax.annotation.Resource;

@Component
@EnableScheduling
@Slf4j
public class UploadDataTask {

    @Autowired
    private EnterpriseService enterpriseService;
    @Resource
    private InFactoryVehicleInfoService inFactoryVehicleInfoService;
    @Resource
    private InAndOutDateService inAndOutDateService;
    @Resource
    private NoRoadVehicleInfoService noRoadVehicleInfoService;
    @Resource
    private ExceedEmissionVehicleService exceedEmissionVehicleService;
    @Resource
    private ControlMeasureService controlMeasureService;
    @Resource
    private PassedThroughService passedThroughService;

    /**
     * 上传企业信息
     */
    // @Scheduled(cron = "0 0/1 * * * *")
    public void uploadEnterpriseInfo() {
        log.info("上传企业信息");
        try {
            enterpriseService.uploadEnterpriseInfo();
        } catch (Exception e) {
            log.error("上传企业信息异常", e);
        }
    }


    /**
     * 进出厂车辆电子台账
     * 一条进场，一条出场
     */
    // @Scheduled(cron = "0 0/1 * * * *")
    public void inAndOutInfo() {
        log.info("上传进出厂车辆电子台账");
        try {
            inAndOutDateService.uploadInfo();
        } catch (Exception e) {
            log.error("上传进出厂车辆电子台账异常", e);
        }
    }

    /**
     * 厂内运输车辆电子台账
     */
    // @Scheduled(cron = "0 0/1 * * * *")
    public void inFactoryInfo() {
        log.info("上传厂内车辆信息");
        try {
            inFactoryVehicleInfoService.uploadInfo();
        } catch (Exception e) {
            log.error("上传厂内车辆信息异常", e);
        }
    }

    /**
     * 非道路移动机械电子台账
     */
    // @Scheduled(cron = "0 0/1 * * * *")
    public void noNoRoadInfo() {
        log.info("上传厂内车辆信息");
        try {
            noRoadVehicleInfoService.uploadInfo();
        } catch (Exception e) {
            log.error("上传厂内车辆信息异常", e);
        }
    }

    /**
     * 排放超标车辆名单表
     */
    // @Scheduled(cron = "0 0/1 * * * *")
    public void exceedEmissionVehicle() {
        log.info("上传厂内车辆信息");
        try {
            exceedEmissionVehicleService.receiveInfo();
        } catch (Exception e) {
            log.error("上传厂内车辆信息异常", e);
        }
    }

    /**
     * 移动源管控措施表
     */
    // @Scheduled(cron = "0 0/1 * * * *")
    public void controlMeasure() {
        log.info("上传厂内车辆信息");
        try {
            controlMeasureService.receiveInfo();
        } catch (Exception e) {
            log.error("上传厂内车辆信息异常", e);
        }
    }

    /**
     * 违规车辆通行车辆名单表
     */
    // @Scheduled(cron = "0 0/1 * * * *")
    public void passedThrough() {
        log.info("上传厂内车辆信息");
        try {
            passedThroughService.receiveInfo();
        } catch (Exception e) {
            log.error("上传厂内车辆信息异常", e);
        }
    }


}
