package com.bme.access.guangdong;

import com.alibaba.druid.pool.DruidDataSource;
import org.mybatis.spring.annotation.MapperScan;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.autoconfigure.SpringBootApplication;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.context.annotation.Bean;

@SpringBootApplication
@MapperScan("com.bme.access.guangdong.dao")
public class Application {
    @ConfigurationProperties(prefix = "spring.datasource.original")
    @Bean
    public DruidDataSource dataSource() {
        return new DruidDataSource();
    }
    public static void main(String[] args) {
        SpringApplication.run(Application.class, args);
    }
}
