package com.bme.access.guangdong.service;

import cn.hutool.core.collection.CollectionUtil;
import com.alibaba.fastjson.JSON;
import com.bme.access.guangdong.common.HttpUtils;
import com.bme.access.guangdong.dao.InOutGateMapper;
import com.bme.access.guangdong.model.*;
import com.bme.access.guangdong.utils.AESPKCS7PaddingUtils;
import lombok.extern.slf4j.Slf4j;
import org.json.JSONObject;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;

@Service
@Slf4j
public class InOutGateService {

    @Autowired
    private LoginService loginService;
    @Autowired
    private InOutGateMapper mapper;

    private static String host = "http://113.96.111.154:18830";
    private static String url = "/api/qymj/pushGate";

    public void uploadInOutGateInfo() {
        // 查询企业信息
        InOutGateInfo inOutGateInfo;
        List<InOutGateOriginalInfo> originalInfos = mapper.getInOutGateInfos();
        if (CollectionUtil.isNotEmpty(originalInfos)) {
            for (InOutGateOriginalInfo originalInfo : originalInfos) {
                inOutGateInfo = convertInfo(originalInfo);
                String jsonStr = JSON.toJSONString(inOutGateInfo);
                String sign = getSign(jsonStr);
                // 使用AES密钥进行加密
                InOutGate inOutGate = new InOutGate();
                BeanUtils.copyProperties(inOutGateInfo, inOutGate);
                inOutGate.setSIGN(sign);
                LoginResult loginResult = loginService.login();
                String key = "";
                if (Objects.nonNull(loginResult) && Objects.nonNull(loginResult.getData())) {
                    key = loginResult.getData().getAes_secret();
                }
                inOutGate.setSIGN(AESPKCS7PaddingUtils.encrypt(inOutGate.getSIGN(), key));
                inOutGate.setQYBH(AESPKCS7PaddingUtils.encrypt(inOutGate.getQYBH(), key));
                inOutGate.setCRKBH(AESPKCS7PaddingUtils.encrypt(inOutGate.getCRKBH(), key));
                inOutGate.setSFYSSSP(AESPKCS7PaddingUtils.encrypt(inOutGate.getSFYSSSP(), key));
                inOutGate.setRTSPURL(AESPKCS7PaddingUtils.encrypt(inOutGate.getRTSPURL(), key));
                inOutGate.setCRKMC(AESPKCS7PaddingUtils.encrypt(inOutGate.getCRKMC(), key));
                String jsonData = JSON.toJSONString(inOutGate);
                try {
                    HttpUtils.sendPost(host, url, null, jsonData);
                } catch (Exception e) {
                    log.info(e.getMessage());
                }
            }
        }
    }

    private String getSign(String jsonStr) {
        org.json.JSONObject jsonObj = new org.json.JSONObject(jsonStr);
        Map<String, Object> sortedMap = new TreeMap<>(jsonObj.toMap()); // 使用TreeMap自动排序键值对
        String sortedJsonStr = new JSONObject(sortedMap).toString(); // 将排序后的Map转换回JSON字符串
        try {
            MessageDigest digest = MessageDigest.getInstance("SHA-256");
            byte[] encodedhash = digest.digest(sortedJsonStr.getBytes()); // 生成哈希值字节数组
            return bytesToHex(encodedhash); // 将字节数组转换为十六进制字符串
        } catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
        }
        return "";
    }

    private static String bytesToHex(byte[] bytes) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < bytes.length; i++) {
            sb.append(String.format("%02x", bytes[i]));
        }
        return sb.toString();
    }

    private InOutGateInfo convertInfo(InOutGateOriginalInfo originalInfo) {
        InOutGateInfo inOutGateInfo = new InOutGateInfo();
        inOutGateInfo.setRTSPURL(originalInfo.getVideoUrl());
        inOutGateInfo.setSFYSSSP(String.valueOf(originalInfo.getHasVideo()));
        inOutGateInfo.setCRKBH(originalInfo.getGateNo());
        inOutGateInfo.setCRKMC(originalInfo.getGateName());
        inOutGateInfo.setQYBH(originalInfo.getEnterpriseNo());
        return inOutGateInfo;
    }


}
