package com.bme.access.guangdong.job;

import com.bme.access.guangdong.service.EnterpriseService;
import com.bme.access.guangdong.service.InFactoryVehicleInfoService;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.annotation.EnableScheduling;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;

import javax.annotation.Resource;

@Component
@EnableScheduling
@Slf4j
public class UploadDataTask {

    @Autowired
    private EnterpriseService enterpriseService;
    @Resource
    private InFactoryVehicleInfoService inFactoryVehicleInfoService;

    /**
     * 上传企业信息
     */
    @Scheduled(cron = "0 0/1 * * * *")
    public void uploadEnterpriseInfo() {
        log.info("上传企业信息");
        try {
            enterpriseService.uploadEnterpriseInfo();
        } catch (Exception e) {
            log.error("上传企业信息异常", e);
        }
    }


    /**
     * 进出厂车辆电子信息
     */

    /**
     * 厂内运输车辆电子台账
     */

    /**
     * 非道路移动机械电子台账
     */

    /**
     * 排放超标车辆名单表
     */


    /**
     * 移动源管控措施表
     */

    /**
     * 违规车辆通行车辆名单表
     */

    /**
     * 上传厂内车辆信息
     */
    @Scheduled(cron = "0 0/1 * * * *")
    public void uploadInFactoryVehicleInfo() {
        log.info("上传厂内车辆信息");
        try {
            inFactoryVehicleInfoService.uploadInfo();
        } catch (Exception e) {
            log.error("上传厂内车辆信息异常", e);
        }
    }

}
