package com.bme.access.guangdong.web;

import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.bme.access.guangdong.model.LoginResult;
import com.bme.access.guangdong.service.LoginService;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.ResponseEntity;
import org.springframework.http.converter.StringHttpMessageConverter;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.client.RestTemplate;

import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Base64;

@RestController
@Slf4j
@RequestMapping
public class TestController {

    private static final String USERACT = "";
    private static final String USERPWD = "";
    private static final String ACTKEY = "";

    @Autowired
    private LoginService loginService;

    @GetMapping("/test")
    public String test() {
        LoginResult result = loginService.login();
        return "";
    }


    @GetMapping("/uploadInfo")
    public String uploadInfo(@RequestParam("method") String method,
                             @RequestParam("version") String version,
                             @RequestParam("cityId") String cityId,
                             @RequestParam("jsonStr") String jsonStr) {
        String businessContent = base64Encode(jsonStr);
        String str = "{" +
                "\"VERSION\":\"" + version + "\"," +
                "\"CITYID\":\"" + cityId + "\"," +
                "\"TYPE\":\"" + method + "\"," +
                "\"BUSINESSCONTENT\":\"" + businessContent + "\"" +
                "}";
        JSONObject data = JSONObject.parseObject(str);
        String dataStr = JSONObject.toJSONString(data, SerializerFeature.WriteMapNullValue);
        // 计算签名
        // USERACT用户账号、USERPWD密码
        String source = USERACT + dataStr + USERPWD;
        String iSign = md5(source); //获取md5并实现二进制小写字符串转换
        //将签名添加进上传的JSON串中
        data.put("ISIGN", iSign);
        //数据上报，在Request Headers添加账户密钥
        //ACTKEY账户密钥
        HttpHeaders httpHeaders = new HttpHeaders();
        httpHeaders.add("AccountKey", ACTKEY);
        httpHeaders.add("Accept-Charset","UTF-8");
        httpHeaders.add("Content-Type", "application/json;charset=UTF-8");
        HttpEntity<JSONObject> requestEntity = new HttpEntity<>(data,httpHeaders);
        RestTemplate restTemplate = new RestTemplate();
        restTemplate.getMessageConverters().set(1, new StringHttpMessageConverter(StandardCharsets.UTF_8));
        ResponseEntity<String> resp = restTemplate.exchange("https://m.gdeei.cn/ydyjgpt/qymj/submitQYMJData", HttpMethod.POST, requestEntity,String.class);
        //获得返回值
        String body = resp.getBody();
        // JSONObject responseObj = JSONObject.parseObject(body);
        //按获取的返回信息完成处理
        //……
        return body;
    }

    /**
     * 完整的MD5编码过程
     *
     * @param input 原始字符串
     * @return 32位小写MD5字符串
     * @throws RuntimeException 当MD5算法不可用时
     */
    private static String md5(String input) {
        // 参数校验
        if (input == null) {
            throw new IllegalArgumentException("Input string cannot be null");
        }
        try {
            // 1. 获取MessageDigest实例
            MessageDigest md = MessageDigest.getInstance("MD5");

            // 2. 将字符串转换为字节数组（必须指定编码）
            byte[] inputBytes = input.getBytes(StandardCharsets.UTF_8);

            // 3. 计算哈希值（digest方法会执行完整计算）
            byte[] hashBytes = md.digest(inputBytes);

            // 4. 将字节数组转换为十六进制表示
            return bytesToHex(hashBytes);

        } catch (NoSuchAlgorithmException e) {
            // 理论上所有Java实现都必须支持MD5
            throw new RuntimeException("MD5 algorithm not available", e);
        }
    }

    /**
     * 字节数组转十六进制字符串（优化版）
     *
     * @param bytes 字节数组
     * @return 十六进制字符串
     */
    private static String bytesToHex(byte[] bytes) {
        // 一个字节对应两个十六进制字符
        char[] hexChars = new char[bytes.length * 2];
        // 预定义十六进制字符
        final char[] hexArray = "0123456789abcdef".toCharArray();

        for (int i = 0; i < bytes.length; i++) {
            // 取字节的高4位
            int high = (bytes[i] & 0xF0) >>> 4;
            // 取字节的低4位
            int low = bytes[i] & 0x0F;
            // 转换为对应的十六进制字符
            hexChars[i * 2] = hexArray[high];
            hexChars[i * 2 + 1] = hexArray[low];
        }
        return new String(hexChars);
    }

    private static String base64Encode(String input) {
        byte[] encodedBytes = Base64.getEncoder().encode(input.getBytes());
        return new String(encodedBytes);
    }

}
