package com.bme.access.guangdong.model;

import com.alibaba.fastjson.annotation.JSONField;
import lombok.Data;

@Data
public class NoRoadVehicleInfo {
    //	行政区划编码	字符（6）	见2.3.2，精确到辖区县
    @JSONField(name = "XZQHDM")
    private String xzqhdm;

    //	企业编号	字符（22）	见2.3.3
    @JSONField(name = "QYBH")
    private String qybh;

    //	环保登记编码	字符（32）	在非道路移动机械监管平台编码登记的编码
    @JSONField(name = "HBDJBM")
    private String hbdjbm;

    //	机械生产日期	日期	格式：YYYYMMDD
    @JSONField(name = "JXSCRQ")
    private String jxscrq;

    //	车牌号码	字符（10）	可选项 若已在公安交管部门上牌请填写
    @JSONField(name = "CPHM")
    private String cphm;

    //	排放标准	字符（1）	见2.3.13
    @JSONField(name = "PFBZ")
    private String pfbz;

    //	燃料类型	字符	见2.3.12
    @JSONField(name = "RLLX")
    private String rllx;

    //	机械种类	字符（1）	见2.3.14
    @JSONField(name = "JXZL")
    private String jxzl;

    //	机械环保代码/产品识别码（PIN）	字符（64）	—
    @JSONField(name = "JXHBDM")
    private String jxhbdm;

    //	机械型号	字符（32）	—
    @JSONField(name = "JXXH")
    private String jxxh;

    //	发动机型号	字符（32）	—
    @JSONField(name = "FDJXH")
    private String fdjxh;

    //	发动机生产厂	字符（100）	—
    @JSONField(name = "FDJSCC")
    private String fdjscc;

    //	发动机编号	字符（32）	—
    @JSONField(name = "FDJBH")
    private String fdjbh;

    //	整车（机）铭牌	字符	JPG格式照片，Base64编码
    @JSONField(name = "ZCMP")
    private String zcmp;

    //	发动机铭牌	字符	JPG格式照片，Base64编码
    @JSONField(name = "FDJMP")
    private String fdjmp;

    //	机械环保信息标签	字符	JPG格式照片，Base64编码
    @JSONField(name = "JXHBXXBQ")
    private String jxhbxxbq;

    //	所属人（单位）	字符（100）	自有/租赁（写明租赁公司名称）
    @JSONField(name = "SSR")
    private String ssr;
}
