package com.bme.access.guangdong.service;

import com.alibaba.fastjson.JSON;
import com.bme.access.guangdong.common.HttpUtils;
import com.bme.access.guangdong.model.LoginResult;
import org.apache.http.HttpResponse;
import org.apache.http.util.EntityUtils;
import org.json.JSONObject;
import org.springframework.stereotype.Service;

import javax.crypto.Cipher;
import java.security.KeyFactory;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.spec.PKCS8EncodedKeySpec;
import java.util.Base64;
import java.util.Map;
import java.util.TreeMap;

@Service
public class LoginService {

    private static String appId = "mj441323gdzhgt$w_8kc_0uf";
    private static String secret = "pBukGgdLKVjKGp-8wbmJfOqX1S5ibTMW";
    private static String path = "/api/qymj/login";
    private static String host = "http://113.96.111.154:18830";

    public LoginResult login() {
        LoginResult loginResult = new LoginResult();
        String se = encryptWithPrivateKey(secret);
        String jsonData = "{\"APPID\": \"" + appId + "\", \"SECRET\": \"" + secret + "\"}";
        String sign = getSign(jsonData);
        String body = "{\"APPID\": \"" + appId + "\", \"SECRET\": \"" + se + "\", \"SIGN\": \"" + sign + "\"}";
        try {
            HttpResponse response = HttpUtils.sendPost(host, path, null, body);
            String result = EntityUtils.toString(response.getEntity());
            loginResult = JSON.parseObject(result, LoginResult.class);
        } catch (Exception e) {
            e.printStackTrace();
        }
        return loginResult;
    }

    private String getSign(String jsonStr) {
        JSONObject jsonObj = new JSONObject(jsonStr);
        Map<String, Object> sortedMap = new TreeMap<>(jsonObj.toMap()); // 使用TreeMap自动排序键值对
        String sortedJsonStr = new JSONObject(sortedMap).toString(); // 将排序后的Map转换回JSON字符串

        try {
            MessageDigest digest = MessageDigest.getInstance("SHA-256");
            byte[] encodedhash = digest.digest(sortedJsonStr.getBytes()); // 生成哈希值字节数组
            String sha256hex = bytesToHex(encodedhash); // 将字节数组转换为十六进制字符串
            // System.out.println(sha256hex); // 输出哈希值
            return encryptWithPrivateKey(sha256hex);
        } catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
        }
        return "";
    }

    private static String bytesToHex(byte[] bytes) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < bytes.length; i++) {
            sb.append(String.format("%02x", bytes[i]));
        }
        return sb.toString();
    }

    private static String encryptWithPrivateKey(String plainText) {
        String privateKeyPEM = "-----BEGIN PRIVATE KEY-----\n" +
                "MIIEvAIBADANBgkqhkiG9w0BAQEFAASCBKYwggSiAgEAAoIBAQDhyADfLz7QruMO\n" +
                "LlSuGo8LGXdOanh06mGVwi8KmTURBwZU2jd9iritYExOW54BuTuYiKZaLn8N9zoM\n" +
                "cQzn4OANTh//3kpqpcNvyyZ5gssRamIM707m0tvC06Rw029vfqwYUFagigNChdF9\n" +
                "KaKbvkMFBvyMyu/QIz+ESp2YEeauwX1g24Ccnyqda1O914z2oBcQXmBsZEjKR+nw\n" +
                "1/RjHeyc9fUecY3lIKMN9R/nSdD0rTGDMnKabl0l28XS89fogy9UWX9Ejx9k91/v\n" +
                "ciQAzYZBD7zdfK+9y8Z4UNRl8/3sDtCxpO+nkmuMSL1TYJfBjelJfFvmPaxx98CG\n" +
                "wNXAp1SVAgMBAAECggEAXZpvUhfiMN3wYBaxIKT+HJnoLmhRnBb3cgDZQ8mUiISj\n" +
                "CVaWnsN+INLFj87HyOskW+57GPQh1IZkWHgd45wFBz8WYRulOmWSiqxsPQAOdB/o\n" +
                "mngz+9n7JeBcUjI2BsE7U7Eq2M+e3ltgKEW0lmDgpBrrZOtVVLLoSE4u27bALj5d\n" +
                "uBNLflc+qByjcaM2Xvi+IXcvmdDo+e4DT8T/0PXoPbUdq2QUe4Qwc173xouQ1w1y\n" +
                "/zEB0Bk4gFJ6ZJhbu2ekASaeTbboO7t4YAOseKFKHdvksBpu/h74OXvKsBbsuFps\n" +
                "kZAmFfR5CbvWv/GyXetNS54xXiykBumZVksMva/7GQKBgQD+GVXGepjawLKW8d3l\n" +
                "4ZJGr/7kHENEc9jyTVYue6YI67/zZ6BfuQVBQnNRBnKRCBel9XoGadvb54FV40sl\n" +
                "F6ezCYtqB7SE4Q2Vdj/UgTdB1H3f9VAVAGmK7sk235anseYayIuQcJ2C5jxTHzMA\n" +
                "UnRjqhy9BCKUdYTLhgdO4uYakwKBgQDjeG7CinjDTvs5cwYb0i8QVQQswv/EoszW\n" +
                "iAKYwOpbeGbDRzRgxehtY2qjPUwXGf8I/oDqqY/Xl69XziphyZuz/RD8RA9UmMuo\n" +
                "aGMOY2+Sp6WH/pahjmLoX3zo/1lHFUnsp0Tn1cCgE8VKt45yyRDJHT1QkBOSqrS4\n" +
                "qhMtpnpFNwKBgC5204iHwou90OppL/ppVSY36JQt1t8dj/4+xhOZ6LKY6XDI8jqO\n" +
                "yrc0P4IBe9GpeSmPydCCawG7Q5tBBOyzdqb2h9fLsObbgHBkPyfMuR4AjUP2x74P\n" +
                "ZT1SjNjL6fCgR0N+iIbREPxuvXk1q03TxhSzdq3Zo7kiBDZzO8LhGtKhAoGATXkq\n" +
                "OCYTZWnUFMgBT55xmx1pk5lCpYVRQMwIHmCuMUM7tMzeoQsm04Llwf1RmhinjTep\n" +
                "TsM7k5E9DinQs4eH+XB6xYCkvApiatRK0I67ZHam4T+rrBCjzUMgdvbpQFWW3PxH\n" +
                "crKRrbOuIXmNEbk7d1P3GyZHFFABx1ddutGVmVcCgYAPkLeLXQ9tX/QHoR9V0I8T\n" +
                "mFOTlAjAsRk9XRq3bgzdhps3J2+SO0WY4PjHtpMsQxUtfVar0VXQjVM4OOE6hZqt\n" +
                "vzkRDT8rANRvF1plDLUR2Yyd8APsRD843dBByAuKzxVhS4DkVU0uCi3wizsJ5YiL\n" +
                "Ub0o3BeLfLrS2ja3ihcwBA==\n" +
                "-----END PRIVATE KEY-----\n";
        // 移除PEM头尾并解码Base64
        String privateKeyContent = privateKeyPEM.replace("-----BEGIN PRIVATE KEY-----", "")
                .replace("-----END PRIVATE KEY-----", "")
                .replaceAll("\\s", ""); // 移除所有空白字符，包括换行符和空格
        byte[] keyBytes = Base64.getDecoder().decode(privateKeyContent);
        try {
            KeyFactory keyFactory = KeyFactory.getInstance("RSA");
            PKCS8EncodedKeySpec keySpec = new PKCS8EncodedKeySpec(keyBytes);
            PrivateKey privateKey = keyFactory.generatePrivate(keySpec);
            Cipher cipher = Cipher.getInstance("RSA/ECB/PKCS1Padding"); // 使用PKCS#1填充模式
            cipher.init(Cipher.ENCRYPT_MODE, privateKey);
            byte[] encryptedBytes = cipher.doFinal(plainText.getBytes());
            return Base64.getEncoder().encodeToString(encryptedBytes); // 返回Base64编码的字符串，便于查看和传输
        } catch (Exception e) {
            e.printStackTrace();
        }
        return "";

    }
}
