package com.bme.access.guangdong.service;

import com.alibaba.fastjson.JSON;
import com.bme.access.guangdong.common.HttpUtils;
import com.bme.access.guangdong.dao.EnterpriseInfoMapper;
import com.bme.access.guangdong.dao.InFactoryTransportVehicleInfoMapper;
import com.bme.access.guangdong.domain.InFactoryTransportVehicleInfoUrl;
import com.bme.access.guangdong.model.EnterpriseOriginalInfo;
import com.bme.access.guangdong.model.InFactoryVehicleInfo;
import com.google.common.collect.Lists;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

import javax.annotation.Resource;
import java.util.List;
import java.util.Objects;

@Slf4j
@Service
public class InFactoryVehicleInfoService {
    @Value("${cityId}")
    private String cityId;
    @Value("${account}")
    private String account;
    @Value("${password}")
    private String password;
    @Value("${key}")
    private String key;


    @Resource
    private InFactoryTransportVehicleInfoMapper inFactoryTransportVehicleInfoMapper;
    @Resource
    private EnterpriseInfoMapper enterpriseInfoMapper;


    public void uploadInfo() {
        // 查询原始数据
        List<InFactoryTransportVehicleInfoUrl> inFactoryTransportVehicleInfoUrls = inFactoryTransportVehicleInfoMapper.selectInFactoryTransportVehicleInfo1();
        if (CollectionUtils.isEmpty(inFactoryTransportVehicleInfoUrls)) {
            return;
        }

        // 查询企业信息
        EnterpriseOriginalInfo enterpriseInfo = enterpriseInfoMapper.getEnterpriseInfo();

        // 转换
        List<InFactoryVehicleInfo> list = Lists.newArrayList();
        inFactoryTransportVehicleInfoUrls.forEach(item -> {
            list.add(convert(item, enterpriseInfo));
        });

        // 发送
        for (List<InFactoryVehicleInfo> partList : Lists.partition(list, 50)) {
            String jsonStr = JSON.toJSONString(partList);
            String result = HttpUtils.uploadData("qyjbxx", "1.0", cityId, jsonStr, account, password, key);
            log.info("返回值resul={}", result);
        }
    }


    public InFactoryVehicleInfo convert(InFactoryTransportVehicleInfoUrl url, EnterpriseOriginalInfo enterpriseInfo) {
        InFactoryVehicleInfo info = new InFactoryVehicleInfo();
        // 企业信息
        if (Objects.nonNull(enterpriseInfo)) {
            info.setXzqhdm(enterpriseInfo.getRegionalismCode());
            info.setQybh(enterpriseInfo.getEnterpriseId());
        }
        info.setHbdjbm(url.getEnvironmentCode());  //环保登记编码
        info.setClsbdm(url.getVin());  //车辆识别代码（VIN）
        if (Objects.nonNull(url.getProductionDate())) {
            info.setScrq(url.getProductionDate());   // TODO  生产日期	日期	格式：YYYYMMDD
        }
        info.setCphm(url.getNumberPlate());
        info.setZcdjrq(url.getRegistrationDate());
        info.setClppxh(url.getModel());
        info.setRllx(url.getFuelType());   //	TODO 燃料类型	字符	见2.3.12
        info.setPfbz(url.getVehicleEmissions());  //	TODO  排放标准	字符（1）	见2.3.13
        //	联网状态	字符（1）	0—未联网；1—已联网
        if (Objects.nonNull(url.getOnlineStatus())) {
            info.setLwzt(url.getOnlineStatus());
        } else {
            info.setLwzt("1");
        }

        info.setScqd(url.getOnBoardList());   //TODO 	随车清单*	字符	JPG格式照片，Base64编码
        info.setXsz(url.getDrivingLicense());  //	TODO 行驶证*	字符	JPG格式照片，Base64编码
        info.setClsyr(url.getOwener());  //	TODO 车辆所有人（单位）	字符（100）	自有/租赁（写明租赁公司名称）
        return info;
    }
}
