# Cypress UI 自动化测试文档

## 概述

本项目使用 Cypress 进行 E2E (端到端) UI 自动化测试，覆盖了 DCTOM 除尘器智能管控平台的核心功能。

## 测试架构

### 技术栈
- **测试框架**: Cypress 13.6.0
- **前端框架**: Vue 3 + Element Plus
- **构建工具**: Vite
- **CI/CD**: GitHub Actions

### 测试标识符策略
所有可测试的 UI 元素都使用 `data-testid` 属性进行标识，遵循以下命名规范：

- 页面容器: `{page-name}-container`
- 表单输入: `{form-name}-{field-name}-input`
- 按钮: `{action-name}-button`
- 表格: `{table-name}-table`
- 卡片组件: `{card-name}-card`

### 目录结构

```
cypress/
├── e2e/                    # E2E 测试用例
│   ├── login.cy.js        # 登录功能测试
│   ├── dashboard.cy.js    # 仪表板功能测试
│   ├── dust-overview.cy.js # 除尘器概览测试
│   └── navigation.cy.js   # 导航菜单测试
├── fixtures/              # 测试数据
│   └── testData.json     # 静态测试数据
├── support/               # 支持文件
│   ├── commands.js       # 自定义命令
│   ├── e2e.js           # E2E 配置
│   └── component.js     # 组件测试配置
└── screenshots/          # 失败时的截图
└── videos/              # 测试录制视频
```

## 核心测试用例

### 1. 登录功能测试 (login.cy.js)

**测试范围:**
- 登录表单元素显示
- 表单验证
- 密码可见性切换
- 验证码刷新
- 记住密码功能
- 键盘导航
- 响应式设计

**关键测试点:**
- 用户名/密码输入验证
- 验证码图片加载和刷新
- 登录状态处理

### 2. 仪表板功能测试 (dashboard.cy.js)

**测试范围:**
- 核心组件渲染
- 健康度指标显示
- 图表数据加载
- 地图组件交互
- 数据更新响应

**关键测试点:**
- 健康度数值格式验证
- 进度条颜色状态
- 图表内容检查
- 响应式布局

### 3. 除尘器概览测试 (dust-overview.cy.js)

**测试范围:**
- 统计卡片显示
- 搜索和筛选功能
- 数据表格操作
- 分页功能
- 新增/编辑操作

**关键测试点:**
- 搜索功能验证
- 表格数据加载
- 操作按钮交互
- 弹窗处理

### 4. 导航菜单测试 (navigation.cy.js)

**测试范围:**
- 菜单项显示
- 导航跳转
- 子菜单展开/收起
- 活跃状态高亮
- 移动端适配

**关键测试点:**
- 菜单权限控制
- 路由跳转验证
- 菜单状态管理

## 自定义命令

项目提供了以下自定义 Cypress 命令：

### 登录相关
```javascript
cy.loginWithUI(username, password)  // UI 登录
```

### 导航相关
```javascript
cy.navigateToPage(pageName)         // 页面导航
```

### 表格相关
```javascript
cy.checkTableDataLoaded(selector)   // 检查表格数据加载
cy.searchInTable(searchText)        // 表格搜索
```

### 响应式测试
```javascript
cy.checkResponsive()                // 检查响应式设计
```

### 健康度验证
```javascript
cy.verifyHealthIndicators()         // 验证健康度指标
```

## 运行测试

### 本地开发

```bash
# 安装依赖
npm install

# 启动开发服务器
npm run dev

# 打开 Cypress 测试界面
npm run cy:open

# 无头模式运行所有测试
npm run cy:run
```

### CI/CD 环境

测试会在以下情况自动触发：
- 推送到 master 或 develop 分支
- 创建 Pull Request 到 master 分支

```bash
# CI 环境运行命令
npm run cy:run:ci
```

## 配置说明

### Cypress 配置 (cypress.config.js)

```javascript
{
  baseUrl: 'http://localhost:5173',    // 应用基础URL
  viewportWidth: 1280,                 // 默认视口宽度
  viewportHeight: 720,                 // 默认视口高度
  defaultCommandTimeout: 10000,       // 命令超时时间
  video: true,                         // 录制视频
  screenshotOnRunFailure: true        // 失败时截图
}
```

### 环境变量

```javascript
env: {
  apiUrl: 'http://localhost:3000',    // API 地址
  username: 'test@example.com',       // 测试用户名
  password: 'testpassword'            // 测试密码
}
```

## 最佳实践

### 1. 测试标识符使用
- 优先使用 `data-testid` 属性
- 避免依赖 CSS 类名或 ID
- 保持标识符语义化和一致性

### 2. 等待策略
```javascript
// ✅ 好的做法
cy.get('[data-testid="submit-button"]').should('be.visible')

// ❌ 避免硬编码等待
cy.wait(5000)
```

### 3. 测试数据管理
- 使用 fixtures 管理静态测试数据
- 在测试前重置数据状态
- 避免测试间的数据依赖

### 4. 断言策略
```javascript
// 检查元素存在性
cy.get('[data-testid="element"]').should('exist')

// 检查元素可见性
cy.get('[data-testid="element"]').should('be.visible')

// 检查元素内容
cy.get('[data-testid="element"]').should('contain', 'Expected Text')
```

## 报告和分析

### 测试结果
- 测试通过/失败统计
- 执行时间分析
- 错误截图和视频录制

### 性能监控
- 集成 Lighthouse CI 进行性能测试
- 监控页面加载时间
- 检查可访问性和 SEO 指标

### CI/CD 集成
- GitHub Actions 自动运行测试
- 测试结果通知
- 失败时的调试信息收集

## 故障排除

### 常见问题

1. **元素未找到**
   - 检查 `data-testid` 是否正确
   - 确认元素是否在 DOM 中渲染
   - 添加适当的等待条件

2. **测试超时**
   - 增加命令超时时间
   - 优化等待策略
   - 检查网络请求响应时间

3. **跨浏览器兼容性**
   - 在多个浏览器中测试
   - 检查浏览器特定的行为差异

### 调试技巧
```javascript
// 添加调试断点
cy.debug()

// 暂停测试执行
cy.pause()

// 在浏览器控制台输出
cy.window().then(console.log)
```

## 扩展计划

1. **组件测试**: 添加 Vue 组件的单元测试
2. **API 测试**: 集成 API 接口测试
3. **视觉回归测试**: 添加 UI 视觉对比测试
4. **性能测试**: 扩展性能监控覆盖范围
5. **移动端测试**: 增加移动设备测试场景

## 维护指南

### 定期维护任务
- 更新测试数据
- 清理过时的测试用例
- 优化测试执行时间
- 更新文档和最佳实践

### 团队协作
- 代码审查测试用例
- 分享测试经验和技巧
- 建立测试用例编写标准
- 定期评估测试覆盖率