/// <reference types="cypress" />

describe('布袋周期管理高级功能测试', () => {
  beforeEach(() => {
    // 模拟登录状态
    cy.mockLogin()
    
    // // 模拟API响应
    // cy.fixture('testData').then((testData) => {
    //   // 模拟获取布袋周期列表API
    //   cy.intercept('GET', '**/bag/cycle/getReplaceListPage', {
    //     statusCode: 200,
    //     body: {
    //       code: 200,
    //       data: testData.collectorListData,
    //       message: 'success'
    //     }
    //   }).as('getCollectorList')
      
    //   // 模拟获取除尘器列表API
    //   cy.intercept('GET', '**/bag/cycle/getDusterList', {
    //     statusCode: 200,
    //     body: {
    //       code: 200,
    //       data: testData.dustAnalysisData.dusterList,
    //       message: 'success'
    //     }
    //   }).as('getDusterList')
      
    //   // 模拟获取分析数据API
    //   cy.intercept('GET', '**/bag/cycle/getReplaceAnalysis', {
    //     statusCode: 200,
    //     body: {
    //       code: 200,
    //       data: testData.dustAnalysisData.analysisData,
    //       message: 'success'
    //     }
    //   }).as('getAnalysisData')
    // })
    
    // 访问布袋周期页面
    cy.visit('/#/collectorList')
    // 等待1秒
    cy.wait(2000)
    
    // 等待页面加载完成
    cy.get('[data-testid="collector-list-container"]').should('be.visible')
  })

  it('应该正确加载和显示表格数据', () => {
    // 等待API请求完成
    cy.wait('@getCollectorList')
    
    // 验证表格数据
    cy.get('[data-testid="collector-common-table"]').within(() => {
      // 检查表格行数量
      cy.get('.el-table__body tr').should('have.length', 3)
      
      // 验证第一行数据
      cy.get('.el-table__body tr').first().within(() => {
        cy.get('td').eq(1).should('contain', '1#除尘器')
        cy.get('td').eq(2).should('contain', 'A仓室')
        cy.get('td').eq(3).should('contain', '1排/1列')
        cy.get('td').eq(4).should('contain', '2024-02-15')
        cy.get('td').eq(5).should('contain', '2024-01-15')
        cy.get('td').eq(6).should('contain', '张三')
        cy.get('td').eq(7).should('contain', '30天')
      })
    })
  })

  it('应该能够进行精确搜索', () => {
    // 等待初始数据加载
    cy.wait('@getCollectorList')
    
    // 模拟搜索API响应
    cy.intercept('GET', '**/bag/cycle/getReplaceListPage*', {
      statusCode: 200,
      body: {
        code: 200,
        data: {
          records: [
            {
              id: 1,
              dusterName: '1#除尘器',
              compart: 'A仓室',
              bagLocation: '1排/1列',
              bagChangeNextTime: '2024-02-15 10:00:00',
              bagChangeTime: '2024-01-15 10:00:00',
              bagChangeAuthor: '张三',
              bagChangePeriod: '30天'
            }
          ],
          total: 1,
          pageNo: 1,
          pageSize: 20
        },
        message: 'success'
      }
    }).as('searchCollectorList')
    
    // 输入搜索条件
    cy.get('[data-testid="collector-compart-input"]').type('A仓室')
    cy.get('[data-testid="collector-duster-name-input"]').type('1#除尘器')
    
    // 点击搜索
    cy.get('[data-testid="collector-search-button"]').click()
    
    // 等待搜索结果
    cy.wait('@searchCollectorList')
    
    // 验证搜索结果
    cy.get('[data-testid="collector-common-table"]').within(() => {
      cy.get('.el-table__body tr').should('have.length', 1)
      cy.get('.el-table__body tr').first().within(() => {
        cy.get('td').eq(1).should('contain', '1#除尘器')
        cy.get('td').eq(2).should('contain', 'A仓室')
      })
    })
  })

  it('应该能够处理分页功能', () => {
    // 等待初始数据加载
    cy.wait('@getCollectorList')
    
    // 模拟第二页数据
    cy.intercept('GET', '**/bag/cycle/getReplaceListPage*pageNo=2*', {
      statusCode: 200,
      body: {
        code: 200,
        data: {
          records: [
            {
              id: 4,
              dusterName: '4#除尘器',
              compart: 'D仓室',
              bagLocation: '2排/2列',
              bagChangeNextTime: '2024-03-01 10:00:00',
              bagChangeTime: '2024-02-01 10:00:00',
              bagChangeAuthor: '赵六',
              bagChangePeriod: '28天'
            }
          ],
          total: 4,
          pageNo: 2,
          pageSize: 20
        },
        message: 'success'
      }
    }).as('getPage2Data')
    
    // 点击下一页
    cy.get('[data-testid="collector-common-table"]').within(() => {
      cy.get('.el-pagination .btn-next').click()
    })
    
    // 等待第二页数据加载
    cy.wait('@getPage2Data')
    
    // 验证第二页数据
    cy.get('[data-testid="collector-common-table"]').within(() => {
      cy.get('.el-table__body tr').should('have.length', 1)
      cy.get('.el-table__body tr').first().within(() => {
        cy.get('td').eq(1).should('contain', '4#除尘器')
        cy.get('td').eq(2).should('contain', 'D仓室')
      })
    })
  })

  it('应该能够打开并操作分析对话框', () => {
    // 等待初始数据加载
    cy.wait('@getCollectorList')
    cy.wait('@getDusterList')
    cy.wait('@getAnalysisData')
    
    // 双击除尘器名称打开对话框
    cy.get('[data-testid="collector-duster-name-link"]').first().dblclick()
    
    // 验证对话框打开
    cy.get('.dustListDialog').should('be.visible')
    cy.get('.el-dialog__title').should('contain', '更换周期分析')
    
    // 验证对话框内容
    cy.get('.dustListDialog').within(() => {
      // 检查除尘器选择器
      cy.get('.input-group').should('be.visible')
      cy.get('.el-select').should('be.visible')
      
      // 检查图表区域
      cy.get('.echartBox').should('be.visible')
    })
    
    // 测试除尘器切换
    cy.get('.dustListDialog .el-select').click()
    cy.get('.el-select-dropdown').should('be.visible')
    cy.get('.el-select-dropdown .el-select-dropdown__item').eq(1).click()
    
    // 验证选择器关闭
    cy.get('.el-select-dropdown').should('not.exist')
    
    // 关闭对话框
    cy.get('.dustListDialog .el-dialog__headerbtn').click()
    cy.get('.dustListDialog').should('not.exist')
  })

  it('应该能够处理日期范围搜索', () => {
    // 等待初始数据加载
    cy.wait('@getCollectorList')
    
    // 模拟日期搜索API响应
    cy.intercept('GET', '**/bag/cycle/getReplaceListPage*', {
      statusCode: 200,
      body: {
        code: 200,
        data: {
          records: [
            {
              id: 2,
              dusterName: '2#除尘器',
              compart: 'B仓室',
              bagLocation: '2排/1列',
              bagChangeNextTime: '2024-02-20 10:00:00',
              bagChangeTime: '2024-01-20 10:00:00',
              bagChangeAuthor: '李四',
              bagChangePeriod: '25天'
            }
          ],
          total: 1,
          pageNo: 1,
          pageSize: 20
        },
        message: 'success'
      }
    }).as('dateSearchResult')
    
    // 设置日期范围
    cy.get('[data-testid="collector-date-picker"]').click()
    cy.get('.el-picker-panel').should('be.visible')
    
    // 选择日期范围（这里需要根据实际的日期选择器实现调整）
    cy.get('.el-picker-panel').within(() => {
      // 选择开始日期
      cy.get('.el-date-table td.available').first().click()
      // 选择结束日期
      cy.get('.el-date-table td.available').eq(5).click()
    })
    
    // 点击搜索
    cy.get('[data-testid="collector-search-button"]').click()
    
    // 等待搜索结果
    cy.wait('@dateSearchResult')
    
    // 验证搜索结果
    cy.get('[data-testid="collector-common-table"]').within(() => {
      cy.get('.el-table__body tr').should('have.length', 1)
    })
  })

  it('应该能够处理空搜索结果', () => {
    // 等待初始数据加载
    cy.wait('@getCollectorList')
    
    // 模拟空搜索结果
    cy.intercept('GET', '**/bag/cycle/getReplaceListPage*', {
      statusCode: 200,
      body: {
        code: 200,
        data: {
          records: [],
          total: 0,
          pageNo: 1,
          pageSize: 20
        },
        message: 'success'
      }
    }).as('emptySearchResult')
    
    // 输入不存在的搜索条件
    cy.get('[data-testid="collector-compart-input"]').type('不存在的仓室')
    cy.get('[data-testid="collector-search-button"]').click()
    
    // 等待搜索结果
    cy.wait('@emptySearchResult')
    
    // 验证空数据状态
    cy.get('[data-testid="collector-common-table"]').should('be.visible')
    cy.get('[data-testid="collector-common-table"]').within(() => {
      // 检查是否有空数据提示或空表格
      cy.get('.el-table__body').should('exist')
    })
  })

  it('应该能够处理API错误', () => {
    // 模拟API错误
    cy.intercept('GET', '**/bag/cycle/getReplaceListPage', {
      statusCode: 500,
      body: {
        code: 500,
        message: '服务器内部错误'
      }
    }).as('apiError')
    
    // 刷新页面或触发搜索
    cy.get('[data-testid="collector-search-button"]').click()
    
    // 等待错误响应
    cy.wait('@apiError')
    
    // 验证页面仍然可用
    cy.get('[data-testid="collector-list-container"]').should('be.visible')
    cy.get('[data-testid="collector-common-table"]').should('be.visible')
  })

  it('应该验证表格排序功能', () => {
    // 等待初始数据加载
    cy.wait('@getCollectorList')
    
    // 检查表格列头是否可点击（排序功能）
    cy.get('[data-testid="collector-common-table"]').within(() => {
      // 检查除尘器名称列是否可以排序
      cy.get('.el-table__header th').contains('除尘器名称').should('be.visible')
      
      // 检查仓室列是否可以排序
      cy.get('.el-table__header th').contains('仓室').should('be.visible')
    })
  })

  it('应该验证表格数据的完整性', () => {
    // 等待初始数据加载
    cy.wait('@getCollectorList')
    
    // 验证所有必需的列都存在
    cy.get('[data-testid="collector-common-table"]').within(() => {
      const expectedColumns = [
        '序号',
        '除尘器名称',
        '仓室',
        '布袋位置（排/列）',
        '布袋更换提醒时间',
        '更换时间',
        '更换人',
        '更换周期(与上次更换比)'
      ]
      
      expectedColumns.forEach(columnName => {
        cy.get('.el-table__header').should('contain', columnName)
      })
    })
  })

  it('应该验证除尘器名称链接的交互性', () => {
    // 等待初始数据加载
    cy.wait('@getCollectorList')
    
    // 验证除尘器名称链接的样式和交互
    cy.get('[data-testid="collector-duster-name-link"]').first().should('have.class', 'health-score')
    cy.get('[data-testid="collector-duster-name-link"]').first().should('have.class', 'green-color')
    
    // 验证链接可以点击
    cy.get('[data-testid="collector-duster-name-link"]').first().should('have.css', 'cursor', 'pointer')
  })

  it('应该验证页面性能指标', () => {
    // 等待页面完全加载
    cy.wait('@getCollectorList')
    
    // 检查页面性能
    cy.window().then((win) => {
      const performance = win.performance
      const navigation = performance.getEntriesByType('navigation')[0]
      
      // 验证DOM内容加载时间
      expect(navigation.domContentLoadedEventEnd - navigation.domContentLoadedEventStart).to.be.lessThan(3000)
      
      // 验证页面完全加载时间
      expect(navigation.loadEventEnd - navigation.loadEventStart).to.be.lessThan(5000)
    })
  })

  it('应该验证搜索表单的验证功能', () => {
    // 测试输入框的最大长度限制
    const longText = 'a'.repeat(1000)
    
    cy.get('[data-testid="collector-compart-input"]').type(longText)
    cy.get('[data-testid="collector-compart-input"]').should('have.value', longText)
    
    cy.get('[data-testid="collector-duster-name-input"]').type(longText)
    cy.get('[data-testid="collector-duster-name-input"]').should('have.value', longText)
    
    // 清除输入
    cy.get('[data-testid="collector-compart-input"]').clear()
    cy.get('[data-testid="collector-duster-name-input"]').clear()
  })

  it('应该验证表格的响应式布局', () => {
    // 等待初始数据加载
    cy.wait('@getCollectorList')
    
    // 测试不同屏幕尺寸下的表格显示
    const viewports = [
      { width: 1920, height: 1080 },
      { width: 1280, height: 720 },
      { width: 768, height: 1024 }
    ]
    
    viewports.forEach(viewport => {
      cy.viewport(viewport.width, viewport.height)
      
      // 验证表格在不同尺寸下仍然可见
      cy.get('[data-testid="collector-common-table"]').should('be.visible')
      
      // 验证表格内容可以滚动（如果需要）
      cy.get('[data-testid="collector-common-table"]').within(() => {
        cy.get('.el-table__body-wrapper').should('be.visible')
      })
    })
  })
})
