import { createWebHistory, createRouter } from 'vue-router'

import Dashboard from '../views/dashboard/index.vue'
import DustOverview from '../views/dustOverview/index.vue'
import AboutView from '../views/AboutView.vue'
import CollectorList from '../views/collectorList/collectorList.vue'
import User from '../views/user.vue'
import Layout from '../layout/index.vue'
import Login from '../views/login/index.vue'
import equipmentManagement from '../views/equipmentManagement/index.vue'
import dustMonitoring from '../views/dustMonitoring/index.vue'
import bagMonitoring from '../views/dustMonitoring/bag-monitoring.vue'

import myAgency from '@/views/closeManage/myAgency.vue';
import myDone from '@/views/closeManage/myDone.vue';
const routes = [
    {
        path: '/',
        component: Layout,
        children: [
          {
            path: '/dashboard',
            component: Dashboard,
            meta: { title: '首页' },
          },
          {
            path: '/dust-overview',
            component: DustOverview,
            meta: { title: '除尘器总览' },
          },
          {
            path: '/device-management',
            component: equipmentManagement,
            meta: { title: '设备管理' },
          },
          {
            path: '/monitor',
            component: dustMonitoring,
            meta: { title: '除尘器监控' },
          },
           {
            path: '/collectorList',
            component: CollectorList,
            meta: { title: '布袋周期' },
          },
          {
            path: '/bag-monitor',
            component: bagMonitoring,
            meta: { title: 'BME布袋监测' },
          },
          {
            path: '/alerts',
            component: AboutView,
            meta: { title: '告警总览' },
          },
          {
            path: '/my-loop',
            meta: { title: '我的闭环' },
            children: [
              {
                path: '/my-loop/myAgency',
                component: myAgency,
                meta: { title: '我的待办' },
              },
              {
                path: '/my-loop/myDone',
                component: myDone,
                meta: { title: '我的已办' },
              },
            ]
          },
        ]
      },
    {
        path: '/login',
        component: Login,
        meta: {
            title: '登录'
        }
    },
]

const router = createRouter({
    history: createWebHistory(),
    routes,
})

export {
    routes,
    router
}