import { createApp } from "vue";
import "./style.css";
import App from "./App.vue";
import { router } from "./router";
import "@/router/routePermission.js";
import zhCustom from "@/locale/zh-custom";
import ElementPlus from "element-plus";
import "element-plus/dist/index.css";
import * as ElementPlusIconsVue from "@element-plus/icons-vue";
import { createPinia } from "pinia";
import moment from 'moment';
const app = createApp(App);
for (const [key, component] of Object.entries(ElementPlusIconsVue)) {
  app.component(key, component);
}
app
  .use(router)
  .use(ElementPlus, { locale: zhCustom })
  .use(moment)
  .use(createPinia())
  .mount("#app");
