import { createApp } from "vue";
import App from "./App.vue";
import { router } from "./router";
import "@/router/routePermission.js";
import zhCustom from "@/locale/zh-custom";
import ElementPlus from "element-plus";
import "element-plus/dist/index.css";
import * as ElementPlusIconsVue from "@element-plus/icons-vue";
import { createPinia } from "pinia";
import moment from 'moment';
import { startPermissionCheck, stopPermissionCheck } from '@/utils/permissionChecker';
import "./style.css";
import "./theme.scss";


const app = createApp(App);
for (const [key, component] of Object.entries(ElementPlusIconsVue)) {
  app.component(key, component);
}
app
  .use(router)
  .use(ElementPlus, { locale: zhCustom })
  .use(moment)
  .use(createPinia())
  .mount("#app");

// 监听路由变化，在登录页停止权限轮询，在其他页面启动权限轮询
router.beforeEach((to, from, next) => {
  if (to.path === '/login') {
    stopPermissionCheck();
  }
  next();
});

router.afterEach((to) => {
  if (to.path !== '/login') {
    startPermissionCheck(5000);
  }
});

// 初始启动权限轮询检查
router.isReady().then(() => {
  if (router.currentRoute.value.path !== '/login') {
    startPermissionCheck(5000);
  }
});
