import { createWebHistory, createRouter } from 'vue-router'

import Dashboard from '../views/dashboard/index.vue'
import DustOverview from '../views/dustOverview/index.vue'
import HomeView from '../views/HomeView.vue'
import AboutView from '../views/AboutView.vue'
import User from '../views/user.vue'
import Layout from '../layout/index.vue'
import Login from '../views/login/index.vue'
import equipmentManagement from '../views/equipmentManagement/index.vue'

const routes = [
    {
        path: '/',
        component: Layout,
        children: [
          {
            path: '/dashboard',
            component: Dashboard,
            meta: { title: '首页' },
          },
          {
            path: '/dust-overview',
            component: DustOverview,
            meta: { title: '除尘器总览' },
          },
          {
            path: '/device-management',
            component: equipmentManagement,
            meta: { title: '设备管理' },
          },
          {
            path: '/monitor',
            component: AboutView,
            meta: { title: '除尘器监控' },
          },
          {
            path: '/alerts',
            component: AboutView,
            meta: { title: '告警总览' },
          },
          {
            path: '/my-loop',
            meta: { title: '我的闭环' },
            children: [
              {
                path: '/my-loop/profile',
                component: HomeView,
                meta: { title: '我的待办' },
              },
              {
                path: '/my-loop/posts',
                component: AboutView,
                meta: { title: '我的已办' },
              },
            ]
          },
        ]
      },
    {
        path: '/login',
        component: Login,
        meta: {
            title: '登录'
        }
    },
]

const router = createRouter({
    history: createWebHistory(),
    routes,
})

export {
    routes,
    router
}