# Cypress 独立测试工具

一个独立的 Cypress 端到端测试工具，可用于测试任何前端应用程序。

## 🚀 快速开始

### 安装依赖
```bash
npm install
```

## 🧪 测试

### Cypress 端到端测试
```bash
# 打开 Cypress 测试界面
npm run cy:open

# 运行所有测试
npm run cy:run

# 运行特定环境的测试
npm run cy:run:dev     # 开发环境测试
npm run cy:run:staging # 预发布环境测试
npm run cy:run:prod    # 生产环境测试
npm run cy:run:custom  # 自定义环境测试

# 使用特定浏览器运行测试
npm run cy:run:electron  # Electron浏览器（默认）
npm run cy:run:chrome  # Chrome浏览器（需要单独安装）
npm run cy:run:firefox # Firefox浏览器（需要单独安装）

# 运行完整测试流程（执行测试+生成报告+生成汇总报告）
npm run test:full
```

### 批量测试
```bash
# 运行所有环境的测试
npm run test:all

# 生成测试报告
npm run test:reports

# 生成测试报告汇总
npm run test:summary

# 运行完整测试流程（执行测试+生成报告+生成汇总报告）
npm run test:full
```

### 测试报告
测试执行完成后会自动生成两种报告：
1. **详细报告** - 包含所有测试用例的详细信息
2. **汇总报告** - 提供图表和统计信息的可视化报告

报告文件位置：
- `public/reports/summary-report.html` - 汇总报告（包含图表和统计信息）
- `public/reports/merged-report.html` - 详细报告（包含所有测试用例详情）

## 🔧 配置

### 环境配置文件

项目包含多个环境配置文件：
- `.env.development` - 开发环境配置
- `.env.staging` - 预发布环境配置
- `.env.production` - 生产环境配置
- `.env.custom` - 自定义环境配置（可随时修改用于测试不同地址）

### 环境变量

支持以下环境变量：
- `CYPRESS_BASE_URL` - 测试目标的基础URL
- `CYPRESS_API_URL` - API接口的基础URL
- `CYPRESS_USERNAME` - 测试用户名
- `CYPRESS_PASSWORD` - 测试密码
- `CYPRESS_REPORT_TITLE` - 测试报告标题
- `CYPRESS_REPORT_PAGE_TITLE` - 测试报告页面标题

### 脚本执行

也可以使用脚本执行测试：
```bash
# 使用脚本执行测试 (Mac/Linux)
./run-tests.sh [environment] [browser]

# 使用脚本执行测试 (Windows)
run-tests.bat [environment] [browser]

# 示例
./run-tests.sh staging chrome
./run-tests.sh custom chrome
./run-tests.sh https://your-website.com chrome  # 直接指定URL
```

脚本会自动执行 `cypress/e2e` 目录下的第一层测试脚本（不包括子目录中的测试），并在测试完成后生成包含图表和统计信息的汇总报告。

## 📁 项目结构

```
cypress/
├── e2e/           # 端到端测试用例
├── support/       # 测试支持文件
│   └── page-objects/ # 页面对象模型
└── fixtures/      # 测试数据
├── reports/       # 测试报告（临时文件）

public/
└── reports/       # 最终测试报告
   ├── summary-report.html      # 汇总报告（图表+统计）
   ├── merged-report.html       # 详细报告（所有测试详情）
   └── merged-report.json       # 报告数据（JSON格式）

.env.development   # 开发环境配置
.env.staging       # 预发布环境配置
.env.production    # 生产环境配置
.env.custom        # 自定义环境配置
run-tests.sh       # 测试执行脚本 (Mac/Linux)
run-tests.bat      # 测试执行脚本 (Windows)
```

## 🛠️ 技术栈

- **测试框架**: Cypress 13.6+
- **报告生成**: Mochawesome

## 📖 使用指南

### 1. 配置测试目标

修改 `.env.development` 文件中的 `CYPRESS_BASE_URL` 为您的开发环境地址。

要测试不同的地址，您可以：
- 修改现有的环境配置文件
- 创建新的环境配置文件
- 直接在运行脚本时指定URL

### 2. 编写测试用例

在 `cypress/e2e/` 目录下创建测试文件，文件名以 `.cy.js` 结尾。

### 3. 运行测试

使用 npm 脚本或直接运行 Cypress 命令执行测试。

### 4. 查看报告

测试执行完成后，会自动生成两种报告：
- **汇总报告** (`public/reports/summary-report.html`)：包含测试结果的图表和统计信息
- **详细报告** (`public/reports/merged-report.html`)：包含所有测试用例的详细信息

## 🔗 相关链接

- [Cypress 文档](https://docs.cypress.io/)