import { defineConfig } from 'cypress'

export default defineConfig({
  e2e: {
    // 使用固定的基础URL，去除环境变量影响
    baseUrl: 'https://screen.bmetech.com',
    viewportWidth: 1280,
    viewportHeight: 720,
    video: true,
    screenshotOnRunFailure: true,
    videosFolder: 'cypress/videos',
    screenshotsFolder: 'cypress/screenshots',
    defaultCommandTimeout: 15000,
    requestTimeout: 15000,
    responseTimeout: 15000,
    pageLoadTimeout: 30000,
    experimentalStudio: true,
    experimentalInteractiveRunEvents: true,
    chromeWebSecurity: false,
    modifyObstructiveCode: false,
    retries: {
      runMode: 2,
      openMode: 0
    },
    setupNodeEvents(on, config) {
      // 固定配置，不依赖环境变量
      if (config.isTextTerminal) {
        config.video = true
        config.screenshotOnRunFailure = true
      }
      return config
    },
    env: {
      // 使用固定的环境配置
      apiUrl: 'https://screen.bmetech.com',
      username: 'zongheng_admin',
      password: '9%#F46vt'
    },
    specPattern: 'cypress/e2e/**/*.cy.{js,jsx,ts,tsx}',
    supportFile: 'cypress/support/e2e.js',
    reporter: 'mochawesome',
    reporterOptions: {
      reportDir: 'cypress/reports',
      overwrite: false,
      html: true,
      json: true,
      timestamp: 'mmddyyyy_HHMMss',
      reportTitle: process.env.CYPRESS_REPORT_TITLE || 'Cypress Tests',
      reportPageTitle: process.env.CYPRESS_REPORT_PAGE_TITLE || '测试报告'
    }
  },
  component: {
    devServer: {
      framework: 'vue',
      bundler: 'vite',
    },
    specPattern: 'src/**/*.cy.{js,jsx,ts,tsx,vue}',
    supportFile: 'cypress/support/component.js'
  }
})