describe('template spec', () => {
  it('DC-TOM首页', function() {
    /* ==== Generated with Cypress Studio ==== */
    cy.visit('https://screen.bmetech.com/admin/dctom/#/login');
    
    // 等待页面加载完成
    cy.waitForPageLoad();
    
    // 执行登录操作
    cy.get('[data-testid="login-username-input"]').clear('zo');
    cy.get('[data-testid="login-username-input"]').type('zongheng_admin');
    cy.get('[data-testid="login-password-input"]').clear('9%#F46vt');
    cy.get('[data-testid="login-password-input"]').type('9%#F46vt');
    cy.get('[data-testid="login-captcha-input"]').clear('8');
    cy.get('[data-testid="login-captcha-input"]').type('8888');
    cy.get('[data-testid="login-submit-button"] > span').click();
    
    // 等待登录API请求完成
    cy.waitForAPIs(3000);
    cy.get('[data-testid="menu-item-dashboard"] > span').click();
    
    // 等待仪表盘页面API请求完成
    cy.waitForAPIs(2000);
    
    cy.get('[data-testid="map-spot-0"] > [data-testid="spot-pulse"]').click();
    
    // 等待地图点击API请求完成
    cy.waitForAPIs(2000);
    
    cy.get('[data-testid="sidebar-menu"]').click();
    cy.get('[data-testid="menu-item-dashboard"]').click();
    cy.get('[data-testid="map-spot-1"] > [data-testid="spot-pulse"]').click();
    
    // 等待地图点击API请求完成
    cy.waitForAPIs(2000);
    
    cy.get('[data-testid="menu-item-dashboard"]').click();
    
    // 等待所有API请求完成
    cy.waitForAPIs(2000);
    
    // 检查API健康状态（可选，用于设置错误阈值）
    cy.checkAPIHealth({
      maxErrors: 10,
      maxSlowRequests: 8,
      maxErrorRate: 50
    });
    
    // API错误信息会自动在测试结束时整合到报告中
    
    /* ==== End Cypress Studio ==== */
  });
})