/// <reference types="cypress" />

describe('登录功能测试', () => {
  beforeEach(() => {
    // 清理localStorage确保每次测试都是干净的状态
    cy.window().then((win) => {
      win.localStorage.clear()
    })
    cy.visit('/#/login')
  })

  it('应该显示登录页面的所有元素', () => {
    // 检查登录页面基本元素
    cy.get('[data-testid="login-username-input"]').should('be.visible')
    cy.get('[data-testid="login-password-input"]').should('be.visible')
    cy.get('[data-testid="login-submit-button"]').should('be.visible')
    cy.get('[data-testid="login-remember-checkbox"]').should('be.visible')
    
    // 检查验证码相关元素（如果存在）
    cy.get('body').then(($body) => {
      if ($body.find('[data-testid="login-captcha-input"]').length > 0) {
        cy.get('[data-testid="login-captcha-input"]').should('be.visible')
        cy.get('[data-testid="login-captcha-image"]').should('be.visible')
      }
    })
  })

  it('应该验证必填字段', () => {
    // 点击登录按钮而不填写任何信息
    cy.get('[data-testid="login-submit-button"]').click()
    
    // 检查错误提示（这里需要根据实际的错误提示元素调整）
    // 由于Element Plus的验证提示可能不在DOM中持久存在，我们可以检查表单是否仍然可见
    cy.get('[data-testid="login-username-input"]').should('be.visible')
  })

  it('应该能够切换密码可见性', () => {
    cy.get('[data-testid="login-password-input"]').type('testpassword')
    
    // Element Plus的密码显示/隐藏按钮 - 使用更具体的选择器
    cy.get('[data-testid="login-password-input"]').find('.el-input__suffix-inner .el-input__icon').click({ force: true })
    
    // 验证密码是否变为可见
    cy.get('[data-testid="login-password-input"] input').should('have.attr', 'type', 'text')
  })


  it('应该能够刷新验证码', () => {
    // 如果验证码图片存在，测试点击刷新
    cy.get('body').then(($body) => {
      if ($body.find('[data-testid="login-captcha-image"]').length > 0) {
        cy.get('[data-testid="login-captcha-image"]')
          .should('be.visible')
          .and('have.attr', 'src')
        
        // 点击验证码图片刷新
        cy.get('[data-testid="login-captcha-image"]').click()
        
        // 验证图片src发生变化（这里需要更复杂的逻辑来验证）
        cy.get('[data-testid="login-captcha-image"]').should('have.attr', 'src')
      }
    })
  })

  it('应该处理登录表单提交', () => {
    // 填写登录信息
    cy.get('[data-testid="login-username-input"]').type('testuser')
    cy.get('[data-testid="login-password-input"]').type('testpassword')
    
    // 如果有验证码输入框，填写验证码
    cy.get('body').then(($body) => {
      if ($body.find('[data-testid="login-captcha-input"]').length > 0) {
        cy.get('[data-testid="login-captcha-input"]').type('1234')
      }
    })
    
    // 提交表单
    cy.get('[data-testid="login-submit-button"]').click()
    
    // 验证是否有加载状态或者跳转（这里需要根据实际情况调整）
    cy.get('[data-testid="login-submit-button"]').should('be.visible')
  })

  it('应该验证响应式设计', () => {
    cy.checkResponsive()
  })

  it('应该正确处理路由跳转到登录页', () => {
    // 尝试直接访问需要权限的页面，应该被重定向到登录页
        // 模拟登录状态
        cy.mockLogin()
        // 等待1秒
        cy.wait(2000)
        // 访问仪表板
        cy.visit('/#/dashboard')
      cy.url().should('include', '/#/dashboard')
    
    // 验证登录页面元素存在
    cy.get('[data-testid="login-username-input"]').should('be.visible')
  })
})