import { defineStore } from 'pinia'
import { getToken, removeToken, setToken } from '@/utils/auth'
import { getInfo, findPcMenu, getLogin, getWeather, login, logout, getFunctionList, captchaLoginFun } from '@/request/user.js'

//第一个参敬是应用程序中store的唯一id,就是给数据仓库起个名字
//第二个参数是一个对象,store的配置项，比如配置store内的嫩据，修改数据的方法等等
export const useUsersStore = defineStore('user', {
    //其他配置项
    //这里的state与vue2中用来存放初始化变量的data的写法相似，需要return
    state: () => {
        return {
            token: getToken('TOKEN'),
            name: '',
            avatar: '',
            introduction: '',
            rememberMe: '',
            dataBranchFactoryId: '',
            roles: [],
            menuLimitsObj: {},
            weather: null,
            customerId: getToken('customerId'),
            office: {},
            istrue: false,
            functionAuthority: getToken('FUNC_AUTHORITY') ? JSON.parse(getToken('FUNC_AUTHORITY')) : '',
        }
    },
    actions: {
        login(userInfo) {
            const { account, password, rememberMe } = userInfo
            return new Promise((resolve, reject) => {
                login(JSON.stringify(userInfo)).then(response => {
                    if (response.code != 1 && response.msg != "密码已过期，请重置！") {
                        return reject(response)
                    }
                    const { data } = response
                    setToken('TOKEN', data)
                    setToken('rememberMe', rememberMe)
                    resolve(response)
                }).catch(error => {
                    resolve(response)
                })
            })
        },
        captchaLogin(userInfo) {
            const { account, password, rememberMe } = userInfo
            return new Promise((resolve, reject) => {
                captchaLoginFun(JSON.stringify(userInfo)).then(response => {
                    if (response.code != 1) {
                        return reject(response)
                    }
                    const { data } = response
                    setToken('TOKEN', data)
                    setToken('rememberMe', rememberMe)
                    resolve(response)
                }).catch(error => {
                    resolve(response)
                })
            })
        },
        getFunctionList(customerId) {
            return new Promise((resolve, reject) => {
                getFunctionList(customerId).then(response => {
                    const { data } = response
                    let obj = {}
                    if (data && data.length) {
                        for (let item of data) {
                            obj[item.code] = item
                        }
                    }
                    this.functionAuthority = obj
                    setToken('FUNC_AUTHORITY', JSON.stringify(obj))
                    resolve(obj)
                }).catch(error => {
                    reject(error)
                })
            })
        },
        logout() {
            return new Promise((resolve, reject) => {
                logout().then((res) => {
                    if (res.code == 1) {
                        this.token = ''
                        this.roles = []
                        removeToken('TOKEN');
                        removeToken('appCode');
                        // resetRouter()
                    }
                    resolve()
                }).catch(error => {
                    reject(error)
                })
            })
        },
        getInfo(userInfo) {
            return new Promise((resolve, reject) => {
                getInfo().then(response => {
                    if (response.code != 1) {
                        return reject('验证失败，请重新登录！')
                    }
                    const { data } = response
                    findPcMenu(this.customerId).then(res => {
                        let menuLimits = res.data
                        let menuLimitsObj = {}
                        if (res.code == 1) {
                            if (menuLimits.length > 0) {
                                for (let item of menuLimits) {
                                    menuLimitsObj[item.configName] = item.configName
                                }
                            }
                            this.menuLimitsObj = menuLimitsObj
                            this.roles = data
                            resolve(data)
                        }
                    })
                }).catch(error => {
                    reject(error)
                })
            })
        },
        resetToken() {
            return new Promise(resolve => {
                this.token = ''
                this.roles = []
                removeToken()
                resolve()
            })
        },
    },
})

