# Cypress Studio 启动器使用说明

## 概述

DC-TOM 项目提供了跨平台的 Cypress Studio 启动器，自动处理开发服务器启动和 Cypress Studio 的启动顺序。

## 功能特性

✅ **自动启动开发服务器** - 确保测试环境就绪  
✅ **智能端口检测** - 自动检测端口占用情况  
✅ **跨平台支持** - Windows/macOS/Linux 全平台兼容  
✅ **进程管理** - 自动清理和停止相关进程  
✅ **错误处理** - 详细的错误提示和解决方案  

## 快速开始

### 通用方法 (推荐)

```bash
# 启动 Cypress Studio (自动启动开发服务器)
npm run studio

# 查看帮助信息
npm run studio:help

# 使用原有命令
npm run cy:open:studio
```

### Windows 专用方法

```cmd
# 方法1: 使用 npm 脚本
npm run studio:win

# 方法2: 直接运行批处理文件
start-studio.bat

# 方法3: 双击 start-studio.bat 文件
```

### macOS/Linux 方法

```bash
# 使用 Node.js 脚本
node start-studio.cjs

# 如果仍有 bash 脚本 (需要可执行权限)
./start-studio.sh
```

## 启动流程

1. **环境检查** - 验证 Node.js、npm、npx 是否可用
2. **端口检测** - 检查 localhost:3000 是否被占用
3. **启动开发服务器** - 如果端口空闲，运行 `npm run dev`
4. **等待就绪** - 等待开发服务器完全启动并响应
5. **启动 Cypress Studio** - 开发环境就绪后启动 Studio

## 故障排除

### 常见问题

**问题**: Windows 下无法执行 `.sh` 脚本  
**解决**: 使用 `npm run studio` 或 `start-studio.bat`

**问题**: 端口 3000 被占用  
**解决**: 
- 启动器会自动跳过开发服务器启动
- 手动停止占用端口的进程
- 或修改项目配置使用其他端口

**问题**: Node.js 或 npm 未找到  
**解决**: 
- 安装 Node.js: https://nodejs.org
- 确保 Node.js 在系统 PATH 中
- 重新打开终端/命令提示符

**问题**: Cypress 启动失败  
**解决**:
- 运行 `npm install` 安装项目依赖
- 检查 Cypress 是否正确安装
- 尝试单独运行 `npx cypress open`

### 手动清理

如果启动器意外退出，可能需要手动清理进程：

```bash
# macOS/Linux
pkill -f "vite"
pkill -f "cypress"

# Windows (命令提示符)
taskkill /f /im node.exe
taskkill /f /im cypress.exe
```

## 文件说明

| 文件名 | 用途 | 平台支持 |
|--------|------|----------|
| `start-studio.cjs` | Node.js 启动脚本 | 全平台 |
| `start-studio.bat` | Windows 批处理文件 | Windows |
| `start-studio.sh` | Bash 脚本 (如存在) | macOS/Linux |

## 自定义配置

### 修改端口

如果需要修改开发服务器端口，编辑 `vite.config.js`:

```javascript
export default defineConfig({
  server: {
    port: 3001  // 修改为其他端口
  }
})
```

同时更新启动器脚本中的端口检测逻辑。

### 添加启动参数

在 `package.json` 中自定义脚本：

```json
{
  "scripts": {
    "studio:custom": "node start-studio.cjs --custom-arg"
  }
}
```

## 技术细节

- **进程管理**: 使用 Node.js `child_process` 模块
- **端口检测**: HTTP 服务器监听测试
- **跨平台**: 自动检测操作系统并调整命令
- **错误处理**: 完整的错误捕获和用户友好提示

## 支持

如果遇到问题，请：

1. 检查 Node.js 版本 (推荐 18+)
2. 确保项目依赖已安装 (`npm install`)
3. 查看启动器输出的错误信息
4. 参考本文档的故障排除部分

---

**注意**: 该启动器专为 DC-TOM 项目设计，但可以适配其他 Vue + Vite + Cypress 项目。