// ***********************************************************
// This example support/e2e.js is processed and
// loaded automatically before your test files.
//
// This is a great place to put global configuration and
// behavior that modifies Cypress.
//
// You can change the location of this file or turn off
// automatically serving support files with the
// 'supportFile' configuration option.
//
// You can read more here:
// https://on.cypress.io/configuration
// ***********************************************************

// Import commands.js using ES2015 syntax:
import './commands'

// Alternatively you can use CommonJS syntax:
// require('./commands')

// 全局配置
Cypress.on('uncaught:exception', (err, runnable) => {
  // 防止Cypress因为应用程序的未捕获异常而失败
  return false
})

// 自定义命令示例
Cypress.Commands.add('login', (username, password) => {
  cy.get('[data-testid="login-username-input"]').type(username)
  cy.get('[data-testid="login-password-input"]').type(password)
  cy.get('[data-testid="login-submit-button"]').click()
})

// 等待页面加载完成
Cypress.Commands.add('waitForPageLoad', () => {
  cy.get('body').should('be.visible')
  cy.wait(500) // 额外等待500ms确保页面完全加载
})

// 检查数据加载
Cypress.Commands.add('waitForDataLoad', (selector, timeout = 10000) => {
  cy.get(selector, { timeout }).should('be.visible')
})