/**
 * 测试生成器核心配置
 * DC-TOM 项目测试描述转测试脚本配置文件
 */

module.exports = {
  // 项目基础配置
  project: {
    name: 'DC-TOM',
    baseUrl: 'http://localhost:3000',
    timeout: 10000
  },

  // 模块路由映射
  moduleRoutes: {
    '登录': 'login',
    '仪表盘': 'dashboard', 
    '除尘器总览': 'dust-overview',
    '布袋周期': 'collectorList',
    '除尘监测': 'monitor',
    '设备管理': 'management/device-management',
    '闭环管理': 'my-loop',
    '告警总览': 'alerts'
  },

  // 测试数据标识符前缀映射
  moduleTestIds: {
    '登录': 'login',
    '仪表盘': 'dashboard',
    '除尘器总览': 'dust',
    '布袋周期': 'collector',
    '除尘监测': 'dust-monitoring',
    '设备管理': 'equipment',
    '闭环管理': 'my-loop',
    '告警总览': 'alerts'
  },

  // 常用组件选择器
  commonSelectors: {
    container: '[data-testid="{module}-container"]',
    searchForm: '[data-testid="{module}-search-form"]',
    table: '[data-testid="{module}-common-table"]',
    searchButton: '[data-testid="{module}-search-button"]',
    resetButton: '[data-testid="{module}-reset-button"]',
    addButton: '[data-testid="{module}-add-button"]',
    editButton: '[data-testid="{module}-edit-button"]',
    deleteButton: '[data-testid="{module}-delete-button"]'
  },

  // Element Plus 组件选择器
  elementSelectors: {
    dialog: '.el-dialog',
    dialogTitle: '.el-dialog__title',
    dialogClose: '.el-dialog__headerbtn',
    table: '.el-table',
    tableHeader: '.el-table__header',
    tableBody: '.el-table__body',
    pagination: '.el-pagination',
    select: '.el-select',
    selectDropdown: '.el-select-dropdown',
    selectItem: '.el-select-dropdown__item',
    datePicker: '.el-date-editor',
    pickerPanel: '.el-picker-panel',
    button: '.el-button',
    input: '.el-input__inner',
    form: '.el-form',
    formItem: '.el-form-item'
  },

  // 输出配置
  output: {
    directory: 'cypress/e2e/generated',
    fileExtension: '.cy.js',
    encoding: 'utf8'
  }
}