@echo off
REM DC-TOM Cypress Studio 启动器 - Windows 批处理版本
REM 功能: 先启动开发服务器，然后启动 Cypress Studio

echo.
echo [INFO] DC-TOM Cypress Studio 启动器 - Windows 版本
echo [INFO] 运行平台: Windows
echo.

REM 检查 Node.js 是否安装
node --version >nul 2>&1
if errorlevel 1 (
    echo [ERROR] Node.js 未安装或不在 PATH 中
    echo 请先安装 Node.js: https://nodejs.org
    pause
    exit /b 1
)

REM 检查 npm 是否可用
npm --version >nul 2>&1
if errorlevel 1 (
    echo [ERROR] npm 未安装或不在 PATH 中
    pause
    exit /b 1
)

REM 运行 Node.js 脚本
echo [INFO] 启动 Cypress Studio 启动器...
node start-studio.cjs %*

REM 检查脚本执行结果
if errorlevel 1 (
    echo.
    echo [ERROR] 启动器执行失败
    echo 可能的解决方案:
    echo 1. 确保项目依赖已安装: npm install
    echo 2. 检查 Cypress 是否正确安装
    echo 3. 确保端口 3000 未被占用
    pause
    exit /b 1
)

echo.
echo [INFO] 启动器执行完成
pause