#!/usr/bin/env node

/**
 * 测试自然语言解析功能
 */

const NaturalLanguageParser = require('./cypress/test-generator/natural-language-parser');
const fs = require('fs');

async function testNaturalLanguageParser() {
    console.log('🧪 测试自然语言解析功能...\n');
    
    try {
        const parser = new NaturalLanguageParser();
        
        // 测试您提供的示例
        const testDescription = `目标页面：首页
测试内容：
1，在告警总览内查询今日布袋告警数据。
2，查询布袋总数
3，在首页查看顶部区域综合健康度的布袋健康度`;
        
        console.log('📝 输入的自然语言描述：');
        console.log(testDescription);
        console.log('\n' + '='.repeat(50) + '\n');
        
        // 解析自然语言
        const parsedResult = parser.parseDescription(testDescription);
        
        console.log('🔍 解析结果：');
        console.log(JSON.stringify(parsedResult, null, 2));
        console.log('\n' + '='.repeat(50) + '\n');
        
        // 生成测试代码
        const testCode = parser.generateTestCode(parsedResult);
        
        console.log('🚀 生成的Cypress测试代码：');
        console.log(testCode);
        
        // 保存到文件
        const outputPath = './test-natural-language-output.cy.js';
        fs.writeFileSync(outputPath, testCode);
        console.log(`\n✅ 测试代码已保存到: ${outputPath}`);
        
    } catch (error) {
        console.error('❌ 测试失败:', error.message);
        console.error(error.stack);
    }
}

// 运行测试
testNaturalLanguageParser();