# DC-TOM API接口测试集成说明

## 📋 概述

已成功在本地CI脚本中集成了首页API接口正确性测试，现在支持独立运行API接口测试并在测试报告中展示结果。

## 🎯 API测试覆盖范围

### 测试的接口
- **健康度概览接口** (`/api/home/health/overview`)
- **健康度统计接口** (`/api/home/health/statistic`)
- **异常监控接口** (`/api/home/exception/monitor`)
- **除尘器告警接口** (`/api/home/duster/alarm`)

### 测试类型
- ✅ 基础功能测试（状态码、响应结构、数据类型）
- ✅ 错误处理测试（服务器错误、认证错误、网络错误）
- ✅ 性能测试（响应时间验证）
- ✅ 并发测试（同时访问多个接口）
- ✅ 数据一致性测试（多次调用数据一致性）

## 🚀 使用方法

### 1. 独立运行API测试
```bash
# 只运行API接口测试
./local-ci.sh api

# 或使用npm脚本
npm run ci:api
```

### 2. 作为完整测试的一部分
```bash
# 运行所有测试（包含API测试）
./local-ci.sh all
# 或
./local-ci.sh
```

### 3. 直接运行Cypress API测试
```bash
# 使用Cypress直接运行
npx cypress run --spec "cypress/e2e/dashboard-api.cy.js"

# 或使用npm脚本
npm run cy:run:api
```

## 📊 测试报告

### 报告结构
API测试结果会包含在以下报告中：

1. **完整测试报告** (`public/reports/merged-report.html`)
   - 包含所有测试类型的汇总结果

2. **API专项报告** (`public/reports/api/`)
   - 专门的API接口测试报告
   - 详细展示每个接口的测试结果

3. **分类报告入口** (`public/index.html`)
   - 提供各类测试报告的快速入口
   - 包含API测试专项链接

### 报告访问
测试完成后，报告会自动在浏览器中打开，您可以：
- 点击"🔗 API接口测试"查看专项API测试结果
- 点击"📊 完整测试报告"查看所有测试的汇总

## 🔧 技术实现

### 文件结构
```
cypress/e2e/
├── dashboard-api.cy.js      # API接口测试脚本
├── login.cy.js             # 基础测试
├── dashboard.cy.js         # 基础测试
└── ...

cypress/reports/
├── api/                    # API测试报告目录
├── basic/                  # 基础测试报告目录
├── business/               # 业务测试报告目录
└── data/                   # 数据测试报告目录

public/
├── reports/
│   ├── merged-report.html  # 汇总报告
│   ├── api/               # API专项报告
│   └── ...
└── index.html             # 报告入口页面
```

### 脚本集成
- **local-ci.sh**: 添加了`api_tests()`函数和`api`测试类型
- **package.json**: 添加了`cy:run:api`和`ci:api`脚本命令

## 🎯 测试验证

API测试会验证以下内容：

### 响应验证
- HTTP状态码正确性
- 响应体结构完整性
- 数据类型正确性
- 业务数据合理性（如健康度0-100%）

### 错误处理
- 服务器错误响应处理
- 认证失败处理
- 网络错误处理
- 超时情况处理

### 性能监控
- 接口响应时间（< 5秒）
- 并发访问性能
- 数据一致性检查

## 📝 使用示例

```bash
# 1. 快速运行API测试
npm run ci:api

# 2. 运行完整测试套件
npm run ci:local

# 3. 查看测试帮助
./local-ci.sh help

# 4. 运行特定类型测试
./local-ci.sh basic     # 基础功能测试
./local-ci.sh api       # API接口测试
./local-ci.sh business  # 业务功能测试
./local-ci.sh data      # 数据管理测试
```

## 🔍 故障排除

如果API测试失败，请检查：
1. 应用服务器是否正常启动（端口3000）
2. 接口是否正常响应
3. 认证TOKEN是否有效
4. 网络连接是否正常

测试报告中会详细记录失败原因和截图，便于问题定位。