# GitLab 12.0.3 兼容性配置说明

## 版本信息

- **GitLab版本**: 12.0.3 (2019年发布)
- **项目**: DC-TOM dctomproject
- **分支**: projects

## 兼容性调整

### 1. 语法替换

#### 使用 `only` 替代 `rules`
GitLab 12.0.3 不支持现代的 `rules` 语法，需要使用传统的 `only/except` 语法：

```yaml
# ✅ GitLab 12.0.3 兼容语法
only:
  - web           # 手动触发
  - projects      # 分支触发
  - merge_requests # MR触发

# ❌ 不兼容语法 (GitLab 12.8+)
rules:
  - if: $CI_PIPELINE_SOURCE == "web"
```

#### 使用 `dependencies` 替代 `needs`
`needs` 关键字在 GitLab 12.3 之后才引入：

```yaml
# ✅ GitLab 12.0.3 兼容语法
dependencies:
  - build

# ❌ 不兼容语法 (GitLab 12.3+)
needs: ["build"]
```

### 2. Docker镜像优化

使用更稳定且兼容的Docker镜像版本：

```yaml
# ✅ 稳定兼容的镜像
image: cypress/browsers:node16.14.2-slim-chrome103-ff102
image: node:16-alpine

# 原配置使用更新的镜像可能有兼容性问题
```

### 3. 功能配置

#### 触发方式
- **自动触发**: 推送到 `projects` 分支、创建MR
- **手动触发**: 通过Web界面手动运行pipeline

#### 测试策略保持不变
- ✅ 基础测试 (login, dashboard, navigation)
- ✅ 完整测试 (所有测试用例) - 手动触发
- ✅ 并行测试 (业务功能组 + 数据管理组) - 手动触发

#### 报告生成
- ✅ 使用 mochawesome 生成HTML报告
- ✅ 自动部署到GitLab Pages
- ✅ 保存截图和视频用于调试

## 使用方法

### 1. 提交代码
```bash
git add .gitlab-ci.yml
git commit -m "feat: GitLab 12.0.3兼容的CI配置"
git push origin projects
```

### 2. 手动触发测试

1. **访问GitLab项目页面**:
   ```
   https://app.bmetech.com/liuzhaohui/dctomproject
   ```

2. **进入CI/CD → Pipelines**

3. **点击"Run Pipeline"**

4. **选择运行的测试**:
   - 默认运行：build + cypress-basic-tests
   - 手动运行：cypress-full-tests (完整测试)
   - 手动运行：cypress-business-tests (业务测试)
   - 手动运行：cypress-data-tests (数据测试)

### 3. 查看结果

- **Pipeline状态**: 在Pipelines页面查看
- **测试报告**: https://liuzhaohui.gitlab.io/dctomproject/
- **下载Artifacts**: 包含截图、视频、详细报告

## GitLab 12.0.3 特殊注意事项

### 限制和特性

1. **需要手动管理依赖关系**
   - `dependencies` 字段需要明确列出前置任务
   - 不支持并行依赖的自动解析

2. **Pipeline可视化有限**
   - 依赖关系图显示相对简单
   - 需要通过任务执行时间推断并行度

3. **缓存功能相对基础**
   - 支持基本的文件缓存
   - 缓存键的表达式功能有限

4. **错误处理相对简单**
   - 重试机制需要手动实现
   - 错误处理逻辑相对基础

### 推荐实践

1. **简化Pipeline结构**
   - 避免过于复杂的依赖关系
   - 使用清晰的stage分层

2. **充分测试配置**
   - 在推送前验证YAML语法
   - 使用GitLab CI Lint工具

3. **监控Pipeline执行**
   - 定期检查pipeline执行状态
   - 及时处理失败的任务

## 升级路径

如果后续升级GitLab版本，可以考虑以下优化：

### GitLab 12.3+ 
- 使用 `needs` 替代 `dependencies`
- 支持更精细的DAG (有向无环图) 控制

### GitLab 12.8+
- 使用 `rules` 替代 `only/except`
- 支持更复杂的条件逻辑

### GitLab 13.0+
- 支持更多的pipeline特性
- 更好的可视化和监控功能

---

## 总结

当前配置完全兼容GitLab 12.0.3，提供了：

- ✅ **稳定的CI/CD流程**
- ✅ **完整的测试覆盖**
- ✅ **详细的测试报告**
- ✅ **灵活的手动触发选项**
- ✅ **良好的错误调试支持**

可以安全地提交和使用！