# 本地 CI 测试使用指南

## 概述

由于 GitLab 环境缺乏 Runner，我们提供了一个本地 CI 脚本来模拟 GitLab CI 流程，可以在本地环境运行完整的测试并生成测试报告。

## 快速开始

### 1. 环境要求

- **Node.js**: 18+ 
- **npm**: 最新版本
- **Chrome浏览器**: 用于 Cypress 测试
- **操作系统**: macOS, Linux 或 Windows (WSL)

### 2. 使用方法

#### 方法一: 使用 Bash 脚本 (推荐)

```bash
# 运行所有测试类型
./local-ci.sh

# 只运行基础测试 (登录、仪表盘、导航)
./local-ci.sh basic

# 只运行完整测试套件
./local-ci.sh full

# 只运行业务功能测试 (除尘器、设备管理、监控)
./local-ci.sh business

# 只运行数据管理测试 (采集器、闭环管理、告警)
./local-ci.sh data

# 查看帮助
./local-ci.sh help
```

#### 方法二: 使用 npm 脚本

```bash
# 运行所有测试
npm run ci:local

# 运行基础测试
npm run ci:basic

# 运行完整测试
npm run ci:full

# 运行业务功能测试
npm run ci:business

# 运行数据管理测试
npm run ci:data
```

## 执行流程

本地 CI 脚本会按以下顺序执行：

```
1. 🔍 环境依赖检查
   ├── Node.js 版本验证
   ├── npm 可用性检查
   └── 项目文件存在性验证

2. 📦 构建阶段
   ├── 安装项目依赖 (npm ci)
   ├── 构建生产版本 (npm run build)
   └── 验证构建结果

3. 🚀 启动应用服务器
   ├── 启动预览服务器 (npm run preview)
   ├── 健康检查 (curl localhost:3000)
   └── 确认服务器可用

4. 🧪 执行 Cypress 测试
   ├── 运行指定的测试套件
   ├── 生成测试视频和截图
   └── 生成 mochawesome 报告

5. 📊 生成测试报告
   ├── 安装报告生成工具
   ├── 合并所有测试报告
   ├── 生成 HTML 格式报告
   ├── 复制媒体文件 (视频/截图)
   └── 生成索引页面

6. 🌐 打开测试报告
   └── 自动在浏览器中打开报告
```

## 测试分类

### 基础测试 (basic)
- **范围**: 核心功能验证
- **包含**: 登录、仪表盘、导航
- **执行时间**: ~5-10分钟
- **用途**: 快速验证核心功能

### 完整测试 (full)  
- **范围**: 所有测试用例
- **包含**: cypress/e2e/*.cy.js
- **执行时间**: ~20-30分钟
- **用途**: 全面功能验证

### 业务功能测试 (business)
- **范围**: 业务核心功能
- **包含**: 除尘器概览、设备管理、监控
- **执行时间**: ~10-15分钟
- **用途**: 业务逻辑验证

### 数据管理测试 (data)
- **范围**: 数据相关功能
- **包含**: 采集器、闭环管理、告警
- **执行时间**: ~10-15分钟
- **用途**: 数据流程验证

## 生成的报告

### 报告结构
```
public/
├── index.html              # 主报告页面
├── reports/
│   ├── merged-report.html   # 详细测试报告
│   └── merged-report.json   # 报告数据
└── assets/
    ├── videos/              # 测试执行视频
    └── screenshots/         # 失败时截图
```

### 报告内容
- **测试概览**: 通过率、失败率、执行时间
- **详细结果**: 每个测试用例的执行状态  
- **失败分析**: 失败用例的错误信息和截图
- **执行视频**: 完整的测试执行过程录像
- **环境信息**: 浏览器版本、测试配置等

## 故障排除

### 常见问题

#### 1. 权限错误
```bash
# 解决方案: 给脚本添加执行权限
chmod +x local-ci.sh
```

#### 2. 端口被占用
```bash
# 解决方案: 关闭占用3000端口的进程
lsof -ti:3000 | xargs kill
```

#### 3. Chrome浏览器未找到
```bash
# macOS 解决方案
brew install --cask google-chrome

# Ubuntu 解决方案  
wget -q -O - https://dl.google.com/linux/linux_signing_key.pub | sudo apt-key add -
sudo apt-get update && sudo apt-get install google-chrome-stable
```

#### 4. 依赖安装失败
```bash
# 清除缓存重新安装
rm -rf node_modules package-lock.json
npm install
```

#### 5. 测试超时
```bash
# 增加 Cypress 超时时间 (在 cypress.config.js 中)
defaultCommandTimeout: 20000
pageLoadTimeout: 60000
```

### 调试模式

如果需要调试特定测试，可以：

```bash
# 1. 手动启动服务器
npm run preview

# 2. 在另一个终端打开 Cypress GUI
npm run cy:open

# 3. 在 GUI 中选择要调试的测试
```

## 与 GitLab CI 的对比

| 功能 | GitLab CI | 本地 CI | 说明 |
|------|-----------|---------|------|
| 环境隔离 | ✅ Docker容器 | ❌ 本地环境 | 本地可能受环境影响 |
| 并行执行 | ✅ 多Runner并行 | ❌ 单线程执行 | 本地执行时间较长 |
| 缓存机制 | ✅ 分布式缓存 | ✅ 本地缓存 | 两者都支持依赖缓存 |
| 报告存储 | ✅ Artifacts+Pages | ✅ 本地文件 | 功能基本相同 |
| 自动触发 | ✅ Git事件触发 | ❌ 手动执行 | 本地需要手动运行 |
| 调试便利性 | ❌ 远程调试困难 | ✅ 本地调试方便 | 本地更便于调试 |

## 最佳实践

### 1. 开发阶段
- 使用 `npm run ci:basic` 进行快速验证
- 修复问题后使用 `npm run ci:full` 进行全面测试

### 2. 发布前
- 运行 `./local-ci.sh` 执行完整的测试流程
- 检查生成的报告确认所有测试通过

### 3. 持续改进
- 定期检查测试执行时间，优化慢速测试
- 分析失败模式，改进测试用例
- 根据项目发展调整测试分组策略

## 自动化增强

可以考虑添加以下自动化功能：

### 1. 定时执行
```bash
# 使用 cron 定时执行
0 2 * * * cd /path/to/project && ./local-ci.sh full
```

### 2. Git Hook 集成
```bash
# 在 .git/hooks/pre-push 中添加
#!/bin/sh
./local-ci.sh basic
```

### 3. Slack 通知
```bash
# 在脚本末尾添加通知
curl -X POST -H 'Content-type: application/json' \
    --data '{"text":"测试完成: '"$test_result"'"}' \
    YOUR_SLACK_WEBHOOK_URL
```

---

## 总结

本地 CI 脚本提供了一个完整的解决方案，可以在 GitLab Runner 不可用的情况下：

✅ **完整模拟 GitLab CI 流程**  
✅ **生成专业的测试报告**  
✅ **支持多种测试策略**  
✅ **提供详细的调试信息**  
✅ **易于使用和扩展**

现在您可以在本地环境获得与 GitLab CI 相同的测试体验！