# 自然语言测试描述指南

## 🎯 概述

DC-TOM项目现在支持使用中文自然语言描述来生成Cypress测试代码，让测试编写变得更加直观和易懂。

## 📝 语法格式

### 基本结构
```
目标页面：[页面名称]
测试内容：
1，[测试步骤描述]
2，[测试步骤描述]
3，[测试步骤描述]
...
```

### 支持的页面模块

| 页面名称 | 对应路由 | 说明 |
|---------|---------|------|
| 首页 | dashboard | 仪表盘主页 |
| 仪表盘 | dashboard | 仪表盘页面 |
| 告警总览 | alerts | 告警管理页面 |
| 设备管理 | management/device-management | 设备管理页面 |
| 布袋周期 | collectorList | 布袋周期管理页面 |
| 除尘器总览 | dust-overview | 除尘器管理页面 |
| 除尘监测 | monitor | 实时监测页面 |
| 闭环管理 | my-loop | 工作流管理页面 |

### 支持的操作动词

| 动词 | 说明 | 生成的Cypress操作 |
|------|------|------------------|
| 查询/搜索/检索 | 搜索操作 | `cy.get().click()` (搜索按钮) |
| 查看/检查/验证 | 验证操作 | `cy.get().should('be.visible')` |
| 点击/单击 | 点击操作 | `cy.get().click()` |
| 输入/填写 | 输入操作 | `cy.get().type()` |
| 选择 | 选择操作 | `cy.get().select()` |

### 支持的数据对象

| 对象名称 | 生成的选择器 | 说明 |
|---------|-------------|------|
| 布袋健康度 | `[data-testid="dashboard-bag-progress"]` | 布袋健康度指标 |
| 综合健康度 | `[data-testid="dashboard-health-score"]` | 综合健康度评分 |
| 布袋总数 | `[data-testid*="bag-total"]` | 布袋总数统计 |
| 告警数据 | `[data-testid*="alert-table"]` | 告警数据表格 |
| 顶部区域 | `.top-area, .header-area` | 页面顶部区域 |

### 支持的时间范围

| 时间描述 | 处理方式 | 说明 |
|---------|----------|------|
| 今日/今天 | 选择今天日期 | 自动点击日期选择器选择今日 |
| 昨日/昨天 | 选择昨天日期 | 选择昨天的日期 |
| 本周 | 选择本周范围 | 选择本周时间范围 |
| 本月 | 选择本月范围 | 选择本月时间范围 |

## 📖 使用示例

### 示例1：仪表盘综合测试
```
目标页面：首页
测试内容：
1，在告警总览内查询今日布袋告警数据。
2，查询布袋总数
3，在首页查看顶部区域综合健康度的布袋健康度
```

**生成的测试代码：**
```javascript
/// <reference types="cypress" />

describe('首页功能测试', () => {
  beforeEach(() => {
    cy.mockLogin()
    cy.visit('/#/dashboard')
    cy.get('[data-testid="dashboard-container"]').should('be.visible')
  })

  it('应该能够在告警总览内查询今日布袋告警数据', () => {
    // 切换到alerts模块
    cy.visit('/#/alerts')
    cy.wait(1000)

    // 在告警总览内查询今日布袋告警数据
    cy.get('[data-testid*="date-picker"]').click()
    cy.get('.el-picker-panel').should('be.visible')
    // 选择今日日期
    cy.get('.el-date-table td.today').click()
    cy.get('[data-testid*="search-button"]').click()
    cy.wait(1000)

    // 验证结果
    cy.get('[data-testid*="alert-table"]').should('be.visible')
  })

  it('应该能够查询布袋总数', () => {
    // 查询布袋总数

    // 验证结果
    cy.get('[data-testid*="bag-total"]').should('be.visible')
  })

  it('应该能够在首页查看顶部区域综合健康度的布袋健康度', () => {
    // 在首页查看顶部区域综合健康度的布袋健康度
    cy.get('[data-testid="dashboard-bag-progress"]').should('be.visible')

    // 验证结果
    cy.get('[data-testid="dashboard-bag-progress"]').should('be.visible')
  })
})
```

### 示例2：设备管理测试
```
目标页面：设备管理
测试内容：
1，搜索设备名称为"除尘器001"的设备
2，验证搜索结果表格显示正常
3，点击重置按钮清空搜索条件
```

### 示例3：布袋周期测试
```
目标页面：布袋周期
测试内容：
1，在仓室输入框中输入"A仓室"
2，在除尘器名称输入框中输入"1#除尘器"
3，点击查询按钮执行搜索
4，验证表格显示搜索结果
5，点击更换周期分析按钮打开对话框
```

## 🚀 使用方法

### 方法1：Web界面（推荐）
1. 启动Web界面：`npm run test-gen:web`
2. 点击"自然语言"标签页
3. 输入中文描述
4. 点击"解析生成测试代码"
5. 复制或下载生成的代码

### 方法2：命令行工具
```bash
# 1. 创建自然语言描述文件（.txt格式）
echo "目标页面：首页
测试内容：
1，查看布袋健康度指标
2，验证数据加载正常" > my-test.txt

# 2. 使用CLI工具解析
cd cypress/test-generator
node cli.js parse my-test.txt

# 3. 或使用集成脚本
./test-generator.sh parse test-descriptions/my-test.txt
```

### 方法3：npm脚本
```bash
# 生成自然语言示例
npm run test-gen:nl-example

# 批量解析所有.txt文件
npm run test-gen:parse
```

## 🎨 高级用法

### 1. 跨模块测试
```
目标页面：首页
测试内容：
1，在首页查看健康度指标
2，切换到告警总览查询告警数据
3，返回首页验证数据一致性
```

### 2. 条件测试
```
目标页面：设备管理
测试内容：
1，如果设备列表为空，显示空状态提示
2，搜索不存在的设备名称
3，验证显示"无数据"提示
```

### 3. 工作流测试
```
目标页面：布袋周期
测试内容：
1，查询即将到期的布袋
2，选择需要更换的布袋
3，提交更换申请
4，验证状态更新
```

## 🔧 自定义扩展

### 添加新的操作动词
在 `natural-language-parser.js` 中的 `actionPatterns` 数组添加：
```javascript
{
  pattern: /拖拽|拖动/,
  action: 'drag',
  description: '拖拽操作'
}
```

### 添加新的数据对象
在 `dataPatterns` 数组添加：
```javascript
{
  pattern: /新的数据类型/,
  type: 'new_data_type',
  selector: '[data-testid="new-data-selector"]'
}
```

### 添加新的页面模块
在 `moduleMapping` 对象添加：
```javascript
'新页面': {
  route: 'new-page',
  testId: 'new-page',
  moduleName: '新页面'
}
```

## 📋 最佳实践

### 1. 描述要清晰具体
✅ 好的描述：
```
在布袋健康度指标中查看当前状态
```

❌ 模糊的描述：
```
看看页面
```

### 2. 使用标准的操作动词
✅ 推荐：
```
1，查询今日告警数据
2，验证表格显示正常
3，点击重置按钮
```

❌ 不推荐：
```
1，弄一下告警数据
2，看看表格对不对
3，搞一下重置
```

### 3. 保持逻辑顺序
✅ 有逻辑的顺序：
```
1，输入搜索条件
2，点击搜索按钮
3，验证搜索结果
4，重置搜索条件
```

### 4. 指定具体的目标
✅ 具体的目标：
```
在仓室输入框中输入"A仓室"
```

❌ 模糊的目标：
```
输入一些内容
```

## 🐛 常见问题

### Q: 解析失败怎么办？
A: 检查以下几点：
- 是否使用了支持的页面名称
- 是否使用了支持的操作动词
- 描述格式是否正确
- 是否包含"目标页面"和"测试内容"

### Q: 生成的选择器不准确？
A: 可以在自然语言解析器中添加更具体的选择器映射，或者在生成后手动调整选择器。

### Q: 如何测试复杂的交互流程？
A: 将复杂流程分解为多个简单步骤，每个步骤使用一个具体的操作动词。

### Q: 支持英文描述吗？
A: 目前主要支持中文描述，英文支持需要扩展解析器的模式匹配。

## 🔮 未来计划

- [ ] 支持更多复杂的条件逻辑
- [ ] 添加更多Element Plus组件的智能识别
- [ ] 支持测试数据的动态生成
- [ ] 集成AI模型提升解析准确度
- [ ] 支持多语言描述（英文、日文等）

---

通过这种自然语言描述方式，您可以用最直观的中文来描述测试需求，系统会自动生成符合项目规范的Cypress测试代码，大大降低了测试编写的技术门槛！