# DC-TOM 项目

基于 Vue 3 + Vite + Element Plus 的现代化前端项目，专为除尘器监控和管理系统设计。

## 🚀 快速开始

### 安装依赖
```bash
npm install
```

### 开发模式
```bash
npm run dev
```

### 构建生产版本
```bash
npm run build
```

## 🧪 测试

### Cypress 端到端测试
```bash
# 打开 Cypress 测试界面
npm run cy:open

# 运行所有测试
npm run cy:run

# 运行特定测试套件
npm run cy:run:basic    # 基础测试
npm run cy:run:business # 业务测试
npm run cy:run:data     # 数据测试
```

### 本地 CI 测试
```bash
# 运行完整的本地 CI 流程
npm run ci:local

# 快速测试
npm run test:quick
```

## 🔧 测试生成器

### 自动化测试生成工具

项目包含了一个强大的测试生成器，可以从JSON描述自动生成Cypress测试代码。

#### 初始化测试生成器
```bash
npm run test-gen:setup
```

#### 生成示例文件
```bash
# JSON格式示例
npm run test-gen:example

# 自然语言描述示例
npm run test-gen:nl-example
```

#### 验证测试描述
```bash
npm run test-gen:validate
```

#### 生成测试代码
```bash
# 从JSON文件生成
npm run test-gen:generate

# 从自然语言描述生成
npm run test-gen:parse
```

#### 运行生成的测试
```bash
npm run test-gen:run
```

#### 启动Web界面
```bash
npm run test-gen:web
```

### 测试描述格式

项目支持两种测试描述方式：

#### 1. 自然语言描述（推荐）

使用中文自然语言直接描述测试场景：

```
目标页面：首页
测试内容：
1，在告警总览内查询今日布袋告警数据。
2，查询布袋总数
3，在首页查看顶部区域综合健康度的布袋健康度
```

支持的操作：查询、查看、点击、输入、验证等
支持的模块：首页、告警总览、设备管理、布袋周期等
支持的时间：今日、昨日、本周、本月等

#### 2. JSON格式描述

使用JSON格式描述测试场景，支持多种测试类型：
- UI验证测试
- 交互功能测试  
- 数据验证测试
- 错误处理测试
- 性能测试
- 响应式设计测试

详细使用说明请参考：
- [测试生成器文档](cypress/test-generator/README.md)
- [自然语言测试指南](NATURAL_LANGUAGE_TESTING_GUIDE.md)

## 📁 项目结构

```
src/
├── components/     # 公共组件
├── layout/        # 布局组件
├── views/         # 页面组件
├── pinia/         # 状态管理
├── router/        # 路由配置
├── request/       # API 请求
└── utils/         # 工具函数

cypress/
├── e2e/           # 端到端测试
├── test-generator/ # 测试生成器
├── support/       # 测试支持文件
└── fixtures/      # 测试数据
```

## 🛠️ 技术栈

- **前端框架**: Vue 3.5+ (Composition API + `<script setup>`)
- **构建工具**: Vite 6.3+
- **UI组件库**: Element Plus 2.9+
- **状态管理**: Pinia 3.0+
- **路由**: Vue Router 4.5+
- **图表库**: ECharts 5.6+
- **HTTP客户端**: Axios 1.9+
- **测试框架**: Cypress 13.6+
- **样式预处理**: Sass 1.88+

## 📖 开发指南

### 代码规范
- 使用 Vue 3 Composition API
- 遵循 `<script setup>` 语法
- 使用 TypeScript (可选)
- 统一的代码格式化

### 测试策略
- 分层测试：基础、业务、数据
- 自动化测试生成
- CI/CD 集成
- 测试报告生成

## 🔗 相关链接

- [Vue 3 文档](https://vuejs.org/)
- [Vite 文档](https://vitejs.dev/)
- [Element Plus 文档](https://element-plus.org/)
- [Cypress 文档](https://docs.cypress.io/)

Learn more about IDE Support for Vue in the [Vue Docs Scaling up Guide](https://vuejs.org/guide/scaling-up/tooling.html#ide-support).
