import { defineConfig } from 'cypress'

export default defineConfig({
  e2e: {
    baseUrl: process.env.CYPRESS_baseUrl || 'http://localhost:3000',
    viewportWidth: 1280,
    viewportHeight: 720,
    video: true,
    screenshotOnRunFailure: true,
    videosFolder: 'cypress/videos',
    screenshotsFolder: 'cypress/screenshots',
    defaultCommandTimeout: 15000,  // 增加超时时间适应CI环境
    requestTimeout: 15000,
    responseTimeout: 15000,
    pageLoadTimeout: 30000,
    // Cypress Studio配置
    experimentalStudio: true,
    experimentalInteractiveRunEvents: true,
    chromeWebSecurity: false,  // 允许Studio跨域交互
    modifyObstructiveCode: false,
    retries: {
      runMode: 2,    // CI环境重试2次
      openMode: 0    // 开发环境不重试
    },
    setupNodeEvents(on, config) {
      // CI环境特殊配置
      if (config.isTextTerminal) {
        config.video = true
        config.screenshotOnRunFailure = true
      }
      return config
    },
    env: {
      // 环境变量
      apiUrl: process.env.CYPRESS_baseUrl || 'http://localhost:3000',
      username: 'test@example.com',
      password: 'testpassword'
    },
    specPattern: 'cypress/e2e/**/*.cy.{js,jsx,ts,tsx}',
    supportFile: 'cypress/support/e2e.js',
    reporter: 'mochawesome',
    reporterOptions: {
      reportDir: 'cypress/reports',
      overwrite: false,  // 不覆盖旧报告，由 local-ci.sh 自动清理历史文件
      html: true,
      json: true,
      timestamp: 'mmddyyyy_HHMMss',  // 时间戳格式用于文件排序和清理
      reportTitle: 'DC-TOM Cypress Tests',
      reportPageTitle: 'DC-TOM 测试报告'
    }
  },
  component: {
    devServer: {
      framework: 'vue',
      bundler: 'vite',
    },
    specPattern: 'src/**/*.cy.{js,jsx,ts,tsx,vue}',
    supportFile: 'cypress/support/component.js'
  }
})