# DC-TOM 测试生成器

一个强大的测试描述转测试脚本的自动化工具，支持通过JSON描述快速生成Cypress测试代码。

## 🚀 功能特性

- **JSON驱动**: 使用标准化的JSON格式描述测试场景
- **多种测试类型**: 支持UI验证、交互测试、错误处理、性能测试等
- **模板化生成**: 基于丰富的模板库自动生成测试代码
- **Web界面**: 提供可视化的测试生成界面
- **CLI工具**: 支持命令行批量生成测试
- **Schema验证**: 内置JSON格式验证和错误提示

## 📁 项目结构

```
cypress/test-generator/
├── config.js              # 核心配置文件
├── schema.json            # JSON测试描述Schema
├── template-engine.js     # 测试模板引擎
├── test-code-generator.js # 测试代码生成器
├── cli.js                 # 命令行工具
├── web-interface.html     # Web可视化界面
└── README.md             # 使用说明文档
```

## 🔧 安装与配置

### 1. 环境要求

- Node.js 18+
- 已安装的DC-TOM项目依赖

### 2. 使用方式

#### Web界面方式（推荐）

1. 在浏览器中打开 `web-interface.html`
2. 在左侧输入JSON测试描述
3. 点击"生成测试代码"按钮
4. 在右侧查看生成的Cypress测试代码
5. 复制代码或下载测试文件

#### 命令行方式

```bash
# 进入测试生成器目录
cd cypress/test-generator

# 生成示例JSON文件
node cli.js example

# 验证JSON文件格式
node cli.js validate test-description.json

# 生成测试代码
node cli.js generate test-description.json

# 指定输出文件
node cli.js generate test-description.json -o my-test.cy.js

# 查看帮助
node cli.js help
```

## 📋 JSON测试描述格式

### 基本结构

```json
{
  "testSuite": {
    "name": "测试套件名称",
    "module": "模块名称",
    "description": "测试套件描述",
    "beforeEach": {
      "login": true,
      "visit": "页面路径",
      "waitFor": ["等待的元素选择器"]
    },
    "scenarios": [
      {
        "name": "测试场景名称",
        "type": "测试类型",
        "description": "场景描述",
        "priority": "优先级",
        "steps": [],
        "expectedResults": []
      }
    ]
  }
}
```

### 支持的模块

- `登录` - 用户登录功能
- `仪表盘` - 数据仪表盘
- `除尘器总览` - 除尘器管理
- `布袋周期` - 布袋周期管理
- `除尘监测` - 实时监测
- `设备管理` - 设备管理
- `闭环管理` - 工作流管理
- `告警总览` - 告警管理

### 测试类型

- `ui` - UI组件验证
- `interaction` - 用户交互测试
- `data` - 数据验证测试
- `error` - 错误处理测试
- `performance` - 性能测试
- `responsive` - 响应式设计测试

### 操作类型

| 操作 | 描述 | 参数 |
|------|------|------|
| `click` | 点击元素 | `target`: 目标选择器 |
| `type` | 输入文本 | `target`: 输入框选择器, `value`: 输入值 |
| `select` | 选择下拉选项 | `target`: 选择器, `value`: 选项值 |
| `verify` | 验证元素 | `target`: 选择器, `value.assertion`: 断言类型 |
| `wait` | 等待 | `value`: 等待时间(毫秒) |
| `intercept` | API拦截 | `value`: 拦截配置 |
| `custom` | 自定义命令 | `customCommand`: 自定义命令名 |

### 断言类型

- `be.visible` - 元素可见
- `exist` - 元素存在
- `contain` - 包含文本
- `have.attr` - 具有属性
- `have.value` - 具有值
- `have.class` - 具有CSS类
- `have.length` - 具有长度

## 📖 使用示例

### 示例1: UI验证测试

```json
{
  "testSuite": {
    "name": "布袋周期页面UI验证",
    "module": "布袋周期",
    "scenarios": [
      {
        "name": "应该显示页面核心组件",
        "type": "ui",
        "steps": [
          {
            "action": "verify",
            "target": "{container}",
            "value": { "assertion": "be.visible" },
            "description": "检查主容器"
          },
          {
            "action": "verify",
            "target": "{searchForm}",
            "value": { "assertion": "be.visible" },
            "description": "检查搜索表单"
          }
        ]
      }
    ]
  }
}
```

### 示例2: 交互功能测试

```json
{
  "testSuite": {
    "name": "搜索功能测试",
    "module": "布袋周期",
    "scenarios": [
      {
        "name": "应该能够搜索数据",
        "type": "interaction",
        "steps": [
          {
            "action": "type",
            "target": "[data-testid=\"collector-compart-input\"]",
            "value": "测试仓室",
            "options": { "clear": true },
            "description": "输入仓室名称"
          },
          {
            "action": "click",
            "target": "{searchButton}",
            "description": "点击搜索按钮"
          }
        ],
        "expectedResults": [
          {
            "target": "{table}",
            "assertion": "be.visible"
          }
        ]
      }
    ]
  }
}
```

### 示例3: 错误处理测试

```json
{
  "testSuite": {
    "name": "错误处理测试",
    "module": "布袋周期",
    "scenarios": [
      {
        "name": "应该处理API错误",
        "type": "error",
        "steps": [
          {
            "action": "intercept",
            "value": {
              "method": "GET",
              "url": "**/bag/cycle/getReplaceListPage",
              "statusCode": 500,
              "error": "服务器错误",
              "alias": "apiError"
            }
          },
          {
            "action": "click",
            "target": "{searchButton}"
          }
        ],
        "expectedResults": [
          {
            "target": "{container}",
            "assertion": "be.visible"
          }
        ]
      }
    ]
  }
}
```

## 🎯 选择器占位符

为了简化选择器编写，系统提供了以下占位符：

| 占位符 | 替换为 | 说明 |
|--------|--------|------|
| `{module}` | 模块ID | 当前模块的测试ID前缀 |
| `{container}` | `[data-testid="{module}-container"]` | 主容器选择器 |
| `{searchForm}` | `[data-testid="{module}-search-form"]` | 搜索表单选择器 |
| `{table}` | `[data-testid="{module}-common-table"]` | 表格选择器 |
| `{searchButton}` | `[data-testid="{module}-search-button"]` | 搜索按钮选择器 |
| `{resetButton}` | `[data-testid="{module}-reset-button"]` | 重置按钮选择器 |

## 🔧 自定义配置

可以通过修改 `config.js` 文件来自定义配置：

```javascript
module.exports = {
  // 添加新的模块路由
  moduleRoutes: {
    '新模块': 'new-module'
  },
  
  // 添加新的选择器模板
  commonSelectors: {
    customButton: '[data-testid="{module}-custom-button"]'
  },
  
  // 修改输出配置
  output: {
    directory: 'cypress/e2e/auto-generated',
    fileExtension: '.spec.js'
  }
}
```

## 📝 最佳实践

### 1. 测试组织

- 按功能模块组织测试
- 使用清晰的测试场景命名
- 合理设置测试优先级

### 2. 选择器策略

- 优先使用 `data-testid` 属性
- 使用占位符简化选择器编写
- 避免依赖CSS类名和ID

### 3. 测试数据

- 使用有意义的测试数据
- 避免硬编码，使用配置化数据
- 考虑边界条件和异常情况

### 4. 错误处理

- 为每个功能添加错误处理测试
- 模拟网络异常和超时
- 验证错误提示和用户体验

## 🐛 故障排除

### 常见问题

1. **JSON格式错误**
   - 检查JSON语法是否正确
   - 使用Web界面的验证功能
   - 查看详细错误信息

2. **模块不支持**
   - 检查模块名称是否在支持列表中
   - 参考config.js中的moduleRoutes配置

3. **选择器无效**
   - 验证选择器是否正确
   - 检查占位符替换是否正确
   - 确认目标元素存在对应的data-testid

4. **生成的代码无法运行**
   - 检查Cypress环境是否正确配置
   - 验证自定义命令是否已定义
   - 检查测试数据是否有效

## 🔄 集成到CI/CD

生成的测试可以直接集成到现有的CI/CD流程：

```bash
# 生成测试文件
node cypress/test-generator/cli.js generate test-descriptions/*.json

# 运行生成的测试
npm run test:generated

# 或使用本地CI脚本
./local-ci.sh business
```

## 📈 扩展开发

### 添加新的测试类型

1. 在 `template-engine.js` 中添加新模板
2. 在 `test-code-generator.js` 中添加处理逻辑
3. 更新 `schema.json` 中的类型定义

### 添加新的操作类型

1. 在 `generateStep` 方法中添加新的case
2. 更新JSON Schema中的操作类型枚举
3. 在Web界面中添加相应的示例

## 🤝 贡献指南

欢迎提交问题报告和功能请求！

1. Fork 项目
2. 创建功能分支
3. 提交更改
4. 推送到分支
5. 创建Pull Request

## 📄 许可证

本项目基于 MIT 许可证开源。