# GitLab CI 集成 Cypress 测试使用指南

## 概述

本项目已成功集成 GitLab CI/CD 与 Cypress E2E 测试，支持自动化测试、手动触发和详细的测试报告生成。

## 配置文件

- `.gitlab-ci.yml` - GitLab CI 配置文件
- `cypress.config.js` - Cypress 测试配置
- `package.json` - 项目依赖和脚本配置

## 测试策略

### 1. 基础测试 (自动触发)
- **触发条件**: 推送到 `projects/e2e-demo` 分支、MR、手动触发
- **测试范围**: 登录、仪表盘、导航等核心功能
- **测试文件**: `{login,dashboard,navigation}.cy.js`

### 2. 完整测试套件 (手动触发)
- **触发条件**: 设置环境变量 `FULL_TEST_SUITE=true`
- **测试范围**: 所有测试用例
- **测试文件**: `cypress/e2e/*.cy.js`

### 3. 并行测试 (手动触发)
- **触发条件**: 设置环境变量 `PARALLEL_TESTS=true`
- **业务功能组**: 除尘器概览、设备管理、监控
- **数据管理组**: 采集器、闭环管理、告警

## 使用方法

### 手动触发测试

1. **进入 GitLab 项目页面**
   ```
   https://app.bmetech.com/liuzhaohui/dctomproject
   ```

2. **导航到 CI/CD → Pipelines**

3. **点击 "Run Pipeline" 按钮**

4. **设置环境变量**（可选）：
   - `FULL_TEST_SUITE`: `true` - 运行完整测试套件
   - `PARALLEL_TESTS`: `true` - 启用并行测试
   - `CYPRESS_baseUrl`: 自定义测试基础URL（默认: http://localhost:3000）

5. **点击 "Run Pipeline" 开始执行**

### 查看测试结果

#### 1. GitLab CI Pipeline 页面
- 查看各个 job 的执行状态
- 下载 Artifacts（截图、视频、报告）

#### 2. GitLab Pages（推荐）
- **访问地址**: `https://liuzhaohui.gitlab.io/dctomproject/`
- **内容包含**:
  - 📊 完整HTML测试报告
  - 🎥 测试执行视频
  - 📸 失败时的截图

#### 3. 本地下载
- Pipeline → Job → Artifacts → Download
- 解压查看详细报告

## 安装依赖

如需在本地运行测试报告生成功能，请安装以下依赖：

```bash
npm install --save-dev mochawesome mochawesome-merge mochawesome-report-generator
```

然后取消注释 `cypress.config.js` 中的 reporter 配置：

```javascript
// 取消注释以下配置
reporter: 'mochawesome',
reporterOptions: {
  reportDir: 'cypress/reports',
  overwrite: false,
  html: true,
  json: true,
  timestamp: 'mmddyyyy_HHMMss',
  reportTitle: 'DC-TOM Cypress Tests',
  reportPageTitle: 'DC-TOM 测试报告'
}
```

## 本地测试脚本

```bash
# 基础测试
npm run cy:run:basic

# 业务功能测试
npm run cy:run:business

# 数据管理测试
npm run cy:run:data

# 完整测试
npm run cy:run:full

# 生成测试报告
npm run test:reports
```

## CI Pipeline 结构

```
stages:
├── build          # 构建阶段
├── test           # 测试阶段
│   ├── cypress-basic-tests      # 基础测试
│   ├── cypress-full-tests       # 完整测试（手动）
│   ├── cypress-business-tests   # 业务测试（并行）
│   └── cypress-data-tests       # 数据测试（并行）
└── reports        # 报告生成阶段
    ├── generate-test-reports    # 合并报告
    └── pages                    # 部署到GitLab Pages
```

## 故障排除

### 常见问题

1. **构建失败**
   - 检查 Node.js 版本（需要 18+）
   - 验证 package.json 语法

2. **测试超时**
   - 检查应用启动状态
   - 增加 `sleep` 等待时间

3. **报告生成失败**
   - 确保测试完成并生成了 JSON 报告
   - 检查 mochawesome 依赖安装

### 调试方法

1. **查看 Pipeline 日志**
   - 每个 job 都有详细的执行日志

2. **下载失败截图**
   - 失败时自动截图保存在 artifacts 中

3. **观看执行视频**
   - 完整的测试执行过程录像

## 配置自定义

### 修改测试分组

编辑 `.gitlab-ci.yml` 中的 `--spec` 参数：

```yaml
# 自定义测试文件分组
--spec "cypress/e2e/{your-test-files}.cy.js"
```

### 调整超时时间

修改 `cypress.config.js` 中的超时配置：

```javascript
defaultCommandTimeout: 15000,  // 命令超时
pageLoadTimeout: 30000,        // 页面加载超时
```

### 自定义报告标题

修改 `reporterOptions` 中的标题配置：

```javascript
reportTitle: '您的测试报告标题',
reportPageTitle: '您的页面标题'
```

## 支持与维护

- **项目地址**: https://app.bmetech.com/liuzhaohui/dctomproject
- **测试报告**: https://liuzhaohui.gitlab.io/dctomproject/
- **技术栈**: Vue 3 + Vite + Cypress + GitLab CI

---

**注意**: 首次运行时可能需要较长时间下载 Docker 镜像和依赖包，后续运行会因为缓存而加快速度。