/// <reference types="cypress" />

describe('除尘器概览功能测试', () => {
  beforeEach(() => {
    // 模拟登录状态
    cy.mockLogin()
    
    // 访问除尘器概览页面
    cy.visit('/#/dust-overview')
  })

  it('应该显示概览页面的所有核心元素', () => {
    // 检查主容器
    cy.get('[data-testid="dust-overview-container"]').should('be.visible')
    
    // 检查头部统计卡片
    cy.get('[data-testid="dust-overview-header"]').should('be.visible')
    cy.get('[data-testid="dust-leak-alarm-card"]').should('be.visible')
    cy.get('[data-testid="dust-health-card"]').should('be.visible')
    cy.get('[data-testid="dust-close-loop-card"]').should('be.visible')
    
    // 检查统计数据
    cy.get('[data-testid="dust-leak-alarm-count"]').should('be.visible')
    cy.get('[data-testid="dust-health-percent"]').should('be.visible')
    cy.get('[data-testid="dust-close-loop-count"]').should('be.visible')
  })

  it('应该显示搜索表单', () => {
    // 检查搜索表单
    cy.get('[data-testid="dust-search-form"]').should('be.visible')
    
    // 检查搜索控件
    cy.get('[data-testid="dust-production-line-select"]').should('be.visible')
    cy.get('[data-testid="dust-device-name-input"]').should('be.visible')
    cy.get('[data-testid="dust-reset-button"]').should('be.visible')
    cy.get('[data-testid="dust-search-button"]').should('be.visible')
    cy.get('[data-testid="dust-add-button"]').should('be.visible')
  })

  it('应该显示数据表格', () => {
    // 检查表格容器
    cy.get('[data-testid="dust-table-container"]').should('be.visible')
    cy.get('[data-testid="dust-table"]').should('be.visible')
    
    // 检查表格是否已加载
    cy.checkTableDataLoaded('[data-testid="dust-table"]')
  })

  it('应该能够执行搜索功能', () => {
    // 使用设备名称搜索
    cy.get('[data-testid="dust-device-name-input"]').clear().type('测试设备')
    cy.get('[data-testid="dust-search-button"]').click()
    
    // 等待搜索结果
    cy.wait(1000)
    
    // 验证表格仍然可见
    cy.get('[data-testid="dust-table"]').should('be.visible')
  })

  it('应该能够使用工序筛选', () => {
    // 点击工序选择框
    cy.get('[data-testid="dust-production-line-select"]').click()
    
    // 选择第一个选项（除了"全部"）
    cy.get('.el-select-dropdown__item').then($items => {
      if ($items.length > 1) {
        cy.wrap($items[1]).click()
        
        // 点击搜索
        cy.get('[data-testid="dust-search-button"]').click()
        cy.wait(1000)
      }
    })
  })

  it('应该能够重置搜索条件', () => {
    // 填写搜索条件
    cy.get('[data-testid="dust-device-name-input"]').type('测试')
    
    // 点击重置按钮
    cy.get('[data-testid="dust-reset-button"]').click()
    
    // 验证输入框已清空
    cy.get('[data-testid="dust-device-name-input"]').should('have.value', '')
  })

  it('应该能够点击统计卡片进行导航', () => {
    // 点击泄漏告警卡片
    cy.get('[data-testid="dust-leak-alarm-card"]').click()
    
    // 验证URL变化或者页面响应
    cy.url().should('not.contain', '/dust-overview')
    
    // 返回概览页面继续测试
    cy.go('back')
    cy.get('[data-testid="dust-overview-container"]').should('be.visible')
    
    // 点击闭环卡片
    cy.get('[data-testid="dust-close-loop-card"]').click()
    cy.url().should('not.contain', '/dust-overview')
    cy.go('back')
  })

  it('应该能够点击表格中的操作按钮', () => {
    // 等待表格数据加载
    cy.checkTableDataLoaded('[data-testid="dust-table"]')
    
    // 检查是否有数据行
    cy.get('[data-testid="dust-table"] tbody tr').then($rows => {
      if ($rows.length > 0) {
        // 点击第一行的查看按钮
        cy.get('[data-testid="dust-view-button"]').first().click()
        
        // 验证跳转或弹窗
        cy.wait(1000)
        
        // 如果是页面跳转，返回
        cy.url().then(url => {
          if (!url.includes('/dust-overview')) {
            cy.go('back')
          }
        })
        
        // 点击编辑按钮
        cy.get('[data-testid="dust-edit-button"]').first().click()
        cy.wait(1000)
      }
    })
  })

  it('应该能够点击仓室数量和电磁阀数量链接', () => {
    // 等待表格加载
    cy.checkTableDataLoaded('[data-testid="dust-table"]')
    
    // 检查仓室数量链接
    cy.get('[data-testid="compartment-count-link"]').then($links => {
      if ($links.length > 0) {
        cy.wrap($links[0]).click()
        cy.wait(1000)
      }
    })
    
    // 检查电磁阀数量链接
    cy.get('[data-testid="valve-count-link"]').then($links => {
      if ($links.length > 0) {
        cy.wrap($links[0]).click()
        cy.wait(1000)
      }
    })
  })

  it('应该能够打开新增弹窗', () => {
    // 点击新增按钮
    cy.get('[data-testid="dust-add-button"]').click()
    
    // 验证弹窗是否打开
    cy.get('.el-dialog').should('be.visible')
    
    // 关闭弹窗
    cy.get('.el-dialog__close').click()
  })

  it('应该验证分页功能', () => {
    // 检查分页组件
    cy.get('[data-testid="pagination-container"]').should('be.visible')
    cy.get('[data-testid="el-pagination"]').should('be.visible')
    
    // 如果有多页数据，测试分页
    cy.get('.el-pagination__total').then($total => {
      const totalText = $total.text()
      if (totalText && totalText.includes('条') && parseInt(totalText) > 20) {
        // 点击下一页
        cy.get('.btn-next').click()
        cy.wait(1000)
        
        // 点击上一页
        cy.get('.btn-prev').click()
        cy.wait(1000)
      }
    })
  })

  it('应该验证响应式设计', () => {
    cy.checkResponsive()
    
    // 验证在不同屏幕尺寸下表格和卡片的显示
    cy.viewport(768, 1024)
    cy.get('[data-testid="dust-overview-header"]').should('be.visible')
    cy.get('[data-testid="dust-table-container"]').should('be.visible')
  })

  it('应该处理数据加载状态', () => {
    // 重新加载页面
    cy.reload()
    cy.waitForPageLoad()
    
    // 验证页面元素正常加载
    cy.get('[data-testid="dust-overview-container"]').should('be.visible')
    cy.get('[data-testid="dust-leak-alarm-count"]').should('be.visible')
    cy.get('[data-testid="dust-health-percent"]').should('be.visible')
    cy.get('[data-testid="dust-close-loop-count"]').should('be.visible')
  })
})