/// <reference types="cypress" />

describe('除尘器监控功能测试', () => {
  beforeEach(() => {
    // 模拟登录状态
    cy.mockLogin()
    
    // 等待登录状态设置完成
    cy.wait(500)
    
    // 访问除尘器监控页面
    cy.visit('/#/monitor')
    
    // 等待页面加载完成
    cy.waitForPageLoad()
  })

  it('应该显示除尘器监控页面的所有核心组件', () => {
    // 检查主容器
    cy.get('[data-testid="dust-monitoring-container"]').should('be.visible')
    
    // 检查筛选区域
    cy.get('[data-testid="dust-monitoring-filters"]').should('be.visible')
    cy.get('[data-testid="dust-monitoring-duster-select"]').should('be.visible')
    cy.get('[data-testid="dust-monitoring-date-picker"]').should('be.visible')
    
    // 检查主要内容区域
    cy.get('[data-testid="dust-monitoring-main-content"]').should('be.visible')
    
    // 检查左侧图表区域
    cy.get('[data-testid="dust-monitoring-charts-section"]').should('be.visible')
    cy.get('[data-testid="dust-monitoring-charts-container"]').should('be.visible')
    cy.get('[data-testid="dust-monitoring-warnings"]').should('be.visible')
    
    // 检查右侧信息区域
    cy.get('[data-testid="dust-monitoring-info-section"]').should('be.visible')
    cy.get('[data-testid="dust-monitoring-health-section"]').should('be.visible')
    cy.get('[data-testid="dust-monitoring-details-section"]').should('be.visible')
  })

  it('应该能够选择除尘器', () => {
    // 点击除尘器选择框
    cy.get('[data-testid="dust-monitoring-duster-select"]').click()
    
    // 等待下拉选项出现
    cy.get('.el-select-dropdown').should('be.visible')
    
    // 如果有选项，选择第一个
    cy.get('.el-select-dropdown').then(($dropdown) => {
      if ($dropdown.find('.el-select-dropdown__item').length > 0) {
        cy.get('.el-select-dropdown__item').first().click()
        
        // 验证选择框有值
        cy.get('[data-testid="dust-monitoring-duster-select"]').should('not.have.value', '')
      }
    })
  })

  it('应该能够设置分析时间范围', () => {
    // 点击日期选择器
    cy.get('[data-testid="dust-monitoring-date-picker"]').click()
    
    // 等待日期面板出现
    cy.get('.el-picker-panel').should('be.visible')
    
    // 选择开始日期
    cy.get('.el-date-table td.available').first().click()
    
    // 选择结束日期
    cy.get('.el-date-table td.available').eq(5).click()
    
    // 点击确定按钮
    cy.get('.el-picker-panel__footer .el-button--primary').click()
    
    // 验证日期选择器有值
    cy.get('[data-testid="dust-monitoring-date-picker"]').should('not.have.value', '')
  })

  it('应该显示健康状态指示器', () => {
    // 检查健康状态组件
    cy.get('[data-testid="dust-monitoring-health-indicator"]').should('be.visible')
    
    // 检查健康状态组件内部是否有内容
    cy.get('[data-testid="dust-monitoring-health-indicator"]').within(() => {
      cy.get('*').should('have.length.gt', 0)
    })
  })

  it('应该显示除尘器详细信息', () => {
    // 检查除尘器标题
    cy.get('[data-testid="dust-monitoring-title"]').should('be.visible')
    
    // 检查信息网格
    cy.get('[data-testid="dust-monitoring-info-grid"]').should('be.visible')
    
    // 检查信息项
    cy.get('[data-testid="dust-monitoring-info-grid"] .info-item').should('be.visible')
  })

  it('应该显示仪表盘指示器', () => {
    // 检查仪表盘区域
    cy.get('[data-testid="dust-monitoring-gauges"]').should('be.visible')
    
    // 检查仪表盘项
    cy.get('[data-testid="dust-monitoring-gauges"] .indicator-item').should('be.visible')
  })

  it('应该显示状态矩阵', () => {
    // 检查状态矩阵区域
    cy.get('[data-testid="dust-monitoring-status-matrix"]').should('be.visible')
    
    // 检查状态矩阵内部是否有内容
    cy.get('[data-testid="dust-monitoring-status-matrix"]').within(() => {
      cy.get('*').should('have.length.gte', 0)
    })
  })

  it('应该显示仓室信息', () => {
    // 检查仓室信息区域
    cy.get('[data-testid="dust-monitoring-compartment-info"]').should('be.visible')
    
    // 检查仓室信息项
    cy.get('[data-testid="dust-monitoring-compartment-info"] .other-info-item').should('be.visible')
  })

  it('应该显示告警信息', () => {
    // 检查告警区域
    cy.get('[data-testid="dust-monitoring-warnings"]').should('be.visible')
    
    // 检查告警组件内部是否有内容
    cy.get('[data-testid="dust-monitoring-warnings"]').within(() => {
      cy.get('*').should('have.length.gte', 0)
    })
  })

  it('应该显示图表数据', () => {
    // 检查图表容器
    cy.get('[data-testid="dust-monitoring-charts-container"]').should('be.visible')
    
    // 检查图表项
    cy.get('[data-testid="dust-monitoring-chart-0"]').should('be.visible')
    
    // 检查图表内部是否有内容
    cy.get('[data-testid="dust-monitoring-chart-0"]').within(() => {
      cy.get('*').should('have.length.gt', 0)
    })
  })

  it('应该响应数据更新', () => {
    // 记录初始状态
    cy.get('[data-testid="dust-monitoring-health-indicator"]').should('be.visible')
    
    // 等待一段时间，检查数据是否可能更新
    cy.wait(2000)
    
    // 验证组件仍然存在
    cy.get('[data-testid="dust-monitoring-health-indicator"]').should('be.visible')
  })

  it('应该处理状态点点击事件', () => {
    // 检查状态矩阵中的状态点
    cy.get('[data-testid="dust-monitoring-status-matrix"] .point').then(($points) => {
      if ($points.length > 0) {
        // 点击第一个状态点
        cy.get('[data-testid="dust-monitoring-status-matrix"] .point').first().click()
        
        // 这里可以添加点击后的验证逻辑
        // 比如检查是否有弹窗、详情页面等
      }
    })
  })

  it('应该处理筛选条件变化', () => {
    // 选择除尘器
    cy.get('[data-testid="dust-monitoring-duster-select"]').click()
    cy.get('.el-select-dropdown').then(($dropdown) => {
      if ($dropdown.find('.el-select-dropdown__item').length > 0) {
        cy.get('.el-select-dropdown__item').first().click()
        
        // 等待数据更新
        cy.wait(1000)
        
        // 验证页面仍然正常显示
        cy.get('[data-testid="dust-monitoring-container"]').should('be.visible')
      }
    })
  })

  it('应该检查响应式设计', () => {
    // 检查不同屏幕尺寸下的显示
    const viewports = [
      { width: 1920, height: 1080 }, // 桌面
      { width: 1280, height: 720 },  // 笔记本
      { width: 768, height: 1024 },  // 平板
    ]
    
    viewports.forEach(viewport => {
      cy.viewport(viewport.width, viewport.height)
      cy.wait(500)
      
      // 验证主要组件仍然可见
      cy.get('[data-testid="dust-monitoring-container"]').should('be.visible')
      cy.get('[data-testid="dust-monitoring-filters"]').should('be.visible')
      cy.get('[data-testid="dust-monitoring-main-content"]').should('be.visible')
    })
  })
})
