/// <reference types="cypress" />

describe('设备管理功能测试', () => {
  beforeEach(() => {
    // 模拟登录状态
    cy.mockLogin()
    
    // 等待登录状态设置完成
    cy.wait(500)
    
    // 访问设备管理页面
    cy.visit('/#/management/device-management')
    
    // 等待页面加载完成
    cy.waitForPageLoad()
  })

  it('应该显示设备管理页面的所有核心组件', () => {
    // 检查主容器
    cy.get('[data-testid="equipment-management-container"]').should('be.visible')
    
    // 检查搜索表单
    cy.get('[data-testid="equipment-management-search-form"]').should('be.visible')
    cy.get('.demo-form-inline').should('be.visible')
    
    // 检查表格区域
    cy.get('[data-testid="equipment-table-container"]').should('be.visible')
  })

  it('应该显示所有搜索条件输入框', () => {
    // 检查工序选择框
    cy.get('[data-testid="equipment-production-line-select"]').should('be.visible')
    
    // 检查除尘器名称输入框
    cy.get('[data-testid="equipment-duster-name-input"]').should('be.visible')
    
    // 检查设备名称输入框
    cy.get('[data-testid="equipment-device-name-input"]').should('be.visible')
    
    // 检查设备类型选择框
    cy.get('[data-testid="equipment-device-type-select"]').should('be.visible')
  })

  it('应该能够输入搜索条件', () => {
    // 输入除尘器名称
    cy.get('[data-testid="equipment-duster-name-input"]').clear().type('测试除尘器')
    cy.get('[data-testid="equipment-duster-name-input"]').should('have.value', '测试除尘器')
    
    // 输入设备名称
    cy.get('[data-testid="equipment-device-name-input"]').clear().type('测试设备')
    cy.get('[data-testid="equipment-device-name-input"]').should('have.value', '测试设备')
  })

  it('应该能够选择工序', () => {
    // 点击工序选择框
    cy.get('[data-testid="equipment-production-line-select"]').click()
    
    // 等待下拉选项出现
    cy.get('.el-select-dropdown').should('be.visible')
    
    // 如果有选项，选择第一个
    cy.get('.el-select-dropdown').then(($dropdown) => {
      if ($dropdown.find('.el-select-dropdown__item').length > 0) {
        cy.get('.el-select-dropdown__item').first().click()
      }
    })
  })

  it('应该能够选择设备类型', () => {
    // 点击设备类型选择框
    cy.get('[data-testid="equipment-device-type-select"]').click()
    
    // 等待下拉选项出现
    cy.get('.el-select-dropdown').should('be.visible')
    
    // 如果有选项，选择第一个
    cy.get('.el-select-dropdown').then(($dropdown) => {
      if ($dropdown.find('.el-select-dropdown__item').length > 0) {
        cy.get('.el-select-dropdown__item').first().click()
      }
    })
  })

  it('应该能够重置搜索条件', () => {
    // 先输入一些搜索条件
    cy.get('[data-testid="equipment-duster-name-input"]').clear().type('测试除尘器')
    cy.get('[data-testid="equipment-device-name-input"]').clear().type('测试设备')
    
    // 点击重置按钮
    cy.get('[data-testid="equipment-reset-button"]').click()
    
    // 验证输入框已清空
    cy.get('[data-testid="equipment-duster-name-input"]').should('have.value', '')
    cy.get('[data-testid="equipment-device-name-input"]').should('have.value', '')
  })

  it('应该能够执行搜索查询', () => {
    // 输入搜索条件
    cy.get('[data-testid="equipment-duster-name-input"]').clear().type('测试除尘器')
    
    // 点击查询按钮
    cy.get('[data-testid="equipment-search-button"]').click()
    
    // 等待搜索结果加载
    cy.wait(1000)
    
    // 验证页面仍然正常显示
    cy.get('[data-testid="equipment-table-container"]').should('be.visible')
  })

  it('应该显示导入按钮', () => {
    // 检查导入按钮
    cy.get('[data-testid="equipment-import-button"]').should('be.visible')
  })

  it('应该显示导出按钮', () => {
    // 检查导出按钮
    cy.get('[data-testid="equipment-export-button"]').should('be.visible')
  })

  it('应该显示模板下载按钮', () => {
    // 检查模板下载按钮
    cy.get('[data-testid="equipment-template-button"]').should('be.visible')
  })

  it('应该能够点击导入按钮', () => {
    // 点击导入按钮
    cy.get('[data-testid="equipment-import-button"]').click()
    
    // 这里可以添加点击后的验证逻辑
    // 比如检查是否有文件选择对话框等
  })

  it('应该能够点击导出按钮', () => {
    // 点击导出按钮
    cy.get('[data-testid="equipment-export-button"]').click()
    
    // 这里可以添加点击后的验证逻辑
    // 比如检查是否有下载开始等
  })

  it('应该能够点击模板下载按钮', () => {
    // 点击模板下载按钮
    cy.get('[data-testid="equipment-template-button"]').click()
    
    // 这里可以添加点击后的验证逻辑
    // 比如检查是否有下载开始等
  })

  it('应该显示设备数据表格', () => {
    // 检查表格容器
    cy.get('[data-testid="equipment-table-container"]').should('be.visible')
    
    // 检查表格组件
    cy.get('.el-table').should('be.visible')
    
    // 检查表格头部
    cy.get('.el-table__header').should('be.visible')
  })

  it('应该显示表格分页组件', () => {
    // 检查分页组件
    cy.get('.el-pagination').should('be.visible')
    
    // 检查分页信息
    cy.get('.el-pagination__total').should('be.visible')
  })

  it('应该能够进行分页操作', () => {
    // 检查分页按钮
    cy.get('.el-pagination__prev').should('be.visible')
    cy.get('.el-pagination__next').should('be.visible')
    
    // 检查页码按钮
    cy.get('.el-pager').should('be.visible')
  })

  it('应该处理表格数据加载', () => {
    // 等待表格数据加载
    cy.wait(1000)
    
    // 验证表格仍然可见
    cy.get('.el-table').should('be.visible')
    
    // 验证表格有内容
    cy.get('.el-table__body').should('be.visible')
  })

  it('应该响应搜索条件变化', () => {
    // 输入搜索条件并查询
    cy.get('[data-testid="equipment-duster-name-input"]').clear().type('测试除尘器')
    cy.get('[data-testid="equipment-search-button"]').click()
    
    // 等待搜索结果
    cy.wait(1000)
    
    // 验证页面正常显示
    cy.get('[data-testid="equipment-table-container"]').should('be.visible')
    
    // 清空搜索条件并查询
    cy.get('[data-testid="equipment-reset-button"]').click()
    cy.get('[data-testid="equipment-search-button"]').click()
    
    // 等待结果
    cy.wait(1000)
    
    // 验证页面正常显示
    cy.get('[data-testid="equipment-table-container"]').should('be.visible')
  })

  it('应该检查响应式设计', () => {
    // 检查不同屏幕尺寸下的显示
    const viewports = [
      { width: 1920, height: 1080 }, // 桌面
      { width: 1280, height: 720 },  // 笔记本
      { width: 768, height: 1024 },  // 平板
    ]
    
    viewports.forEach(viewport => {
      cy.viewport(viewport.width, viewport.height)
      cy.wait(500)
      
      // 验证主要组件仍然可见
      cy.get('[data-testid="equipment-management-container"]').should('be.visible')
      cy.get('[data-testid="equipment-management-search-form"]').should('be.visible')
      cy.get('[data-testid="equipment-table-container"]').should('be.visible')
    })
  })

  it('应该处理空数据状态', () => {
    // 输入一个不存在的搜索条件
    cy.get('[data-testid="equipment-duster-name-input"]').clear().type('不存在的除尘器')
    cy.get('[data-testid="equipment-search-button"]').click()
    
    // 等待搜索结果
    cy.wait(1000)
    
    // 验证页面仍然正常显示
    cy.get('[data-testid="equipment-table-container"]').should('be.visible')
  })

  it('应该验证表格列标题', () => {
    // 检查表格头部
    cy.get('.el-table__header').should('be.visible')
    
    // 检查表格头部行
    cy.get('.el-table__header tr').should('be.visible')
    
    // 检查表格头部单元格
    cy.get('.el-table__header th').should('be.visible')
  })

  it('应该处理文件上传功能', () => {
    // 检查文件上传组件
    cy.get('.upload-demo').should('be.visible')
    
    // 这里可以添加文件上传的测试逻辑
    // 比如模拟文件选择、上传进度等
  })

  it('应该验证按钮状态', () => {
    // 验证所有按钮都是可点击的
    cy.get('[data-testid="equipment-reset-button"]').should('be.enabled')
    cy.get('[data-testid="equipment-search-button"]').should('be.enabled')
    cy.get('[data-testid="equipment-import-button"]').should('be.enabled')
    cy.get('[data-testid="equipment-export-button"]').should('be.enabled')
    cy.get('[data-testid="equipment-template-button"]').should('be.enabled')
  })

  it('应该处理表单验证', () => {
    // 测试表单验证逻辑
    // 这里可以添加各种边界条件的测试
    // 比如空值、特殊字符、超长输入等
    
    // 测试超长输入
    const longText = 'a'.repeat(1000)
    cy.get('[data-testid="equipment-duster-name-input"]').clear().type(longText)
    
    // 验证输入框仍然正常工作
    cy.get('[data-testid="equipment-duster-name-input"]').should('have.value', longText)
  })

  it('应该处理多条件组合搜索', () => {
    // 组合多个搜索条件
    cy.get('[data-testid="equipment-duster-name-input"]').clear().type('测试除尘器')
    cy.get('[data-testid="equipment-device-name-input"]').clear().type('测试设备')
    
    // 选择工序
    cy.get('[data-testid="equipment-production-line-select"]').click()
    cy.get('.el-select-dropdown').then(($dropdown) => {
      if ($dropdown.find('.el-select-dropdown__item').length > 0) {
        cy.get('.el-select-dropdown__item').first().click()
      }
    })
    
    // 选择设备类型
    cy.get('[data-testid="equipment-device-type-select"]').click()
    cy.get('.el-select-dropdown').then(($dropdown) => {
      if ($dropdown.find('.el-select-dropdown__item').length > 0) {
        cy.get('.el-select-dropdown__item').first().click()
      }
    })
    
    // 执行搜索
    cy.get('[data-testid="equipment-search-button"]').click()
    
    // 等待搜索结果
    cy.wait(1000)
    
    // 验证页面正常显示
    cy.get('[data-testid="equipment-table-container"]').should('be.visible')
  })
})
