# CollectorList 组件 Cypress 测试说明

## 概述

本项目为 CollectorList（布袋周期管理）组件提供了完整的 Cypress 端到端测试覆盖，包括基础功能测试、高级功能测试和简化测试。

## 测试文件结构

```
cypress/e2e/
├── collector-list.cy.js          # 基础功能测试
├── collector-list-advanced.cy.js # 高级功能测试（包含API模拟）
├── collector-list-simple.cy.js   # 简化测试（使用自定义命令）
└── README-collector-list.md      # 本说明文档
```

## 测试覆盖范围

### 1. 基础功能测试 (`collector-list.cy.js`)

**测试场景：**
- 页面组件显示验证
- 搜索表单字段验证
- 搜索功能测试
- 重置功能测试
- 日期选择器测试
- 表格数据显示
- 分析对话框功能
- 分页功能验证
- 表格列标题验证
- 空数据处理
- 响应式设计验证
- 输入验证
- 表格交互性
- 页面性能测试
- 错误处理
- 数据刷新功能

### 2. 高级功能测试 (`collector-list-advanced.cy.js`)

**测试场景：**
- API 模拟和数据验证
- 精确搜索功能
- 分页数据处理
- 对话框完整操作流程
- 日期范围搜索
- 空搜索结果处理
- API 错误处理
- 表格排序功能
- 数据完整性验证
- 性能指标验证
- 输入验证边界测试
- 响应式布局测试

### 3. 简化测试 (`collector-list-simple.cy.js`)

**测试场景：**
- 使用自定义命令的基础功能测试
- 页面组件验证
- 搜索和重置功能
- 对话框操作
- 表格验证
- 响应式设计
- 性能测试

## 自定义命令

在 `cypress/support/commands.js` 中添加了以下专门用于 CollectorList 测试的自定义命令：

### 导航命令
- `navigateToCollectorList()` - 导航到布袋周期页面

### 搜索命令
- `searchCollectorData(compart, dusterName, dateRange)` - 搜索布袋周期数据
- `resetCollectorSearch()` - 重置搜索条件

### 对话框命令
- `openAnalysisDialog(method)` - 打开更换周期分析对话框
- `closeAnalysisDialog()` - 关闭分析对话框

### 验证命令
- `verifyCollectorTableData(expectedData)` - 验证表格数据完整性
- `verifyCollectorTableHeaders()` - 验证表格列标题

### API 模拟命令
- `mockCollectorAPI(apiType, responseData)` - 模拟 API 响应

### 工具命令
- `waitForPageLoad()` - 等待页面加载完成

## 测试数据

在 `cypress/fixtures/testData.json` 中添加了专门的测试数据：

### collectorListData
包含布袋周期列表的模拟数据，包括：
- 除尘器名称
- 仓室信息
- 布袋位置
- 更换时间
- 更换人
- 更换周期

### dustAnalysisData
包含分析相关的模拟数据，包括：
- 除尘器列表
- 分析图表数据

## 运行测试

### 运行所有 CollectorList 测试
```bash
npx cypress run --spec "cypress/e2e/collector-list*.cy.js"
```

### 运行特定测试文件
```bash
# 基础功能测试
npx cypress run --spec "cypress/e2e/collector-list.cy.js"

# 高级功能测试
npx cypress run --spec "cypress/e2e/collector-list-advanced.cy.js"

# 简化测试
npx cypress run --spec "cypress/e2e/collector-list-simple.cy.js"
```

### 在浏览器中运行测试
```bash
npx cypress open
```
然后在 Cypress 测试运行器中选择相应的测试文件。

## 测试环境要求

1. **登录状态模拟** - 测试使用 `mockLogin()` 命令模拟用户登录状态
2. **API 模拟** - 高级测试使用 `cy.intercept()` 模拟 API 响应
3. **测试数据** - 使用 `cy.fixture()` 加载测试数据

## 注意事项

1. **data-testid 属性** - 确保 CollectorList 组件中的元素包含正确的 `data-testid` 属性
2. **API 路径** - 测试中的 API 路径需要与实际后端 API 路径匹配
3. **日期选择器** - 日期选择器的测试可能需要根据实际的 Element UI 实现进行调整
4. **响应式测试** - 响应式测试在不同浏览器中可能有不同的表现

## 维护和扩展

### 添加新的测试场景
1. 在相应的测试文件中添加新的 `it()` 测试用例
2. 如果需要，在 `commands.js` 中添加新的自定义命令
3. 在 `testData.json` 中添加相应的测试数据

### 修改现有测试
1. 确保修改后的测试仍然覆盖原有的功能
2. 更新相关的自定义命令和测试数据
3. 验证测试在不同环境下的稳定性

### 调试测试
1. 使用 `cy.debug()` 或 `cy.pause()` 进行调试
2. 查看 Cypress 测试运行器的实时日志
3. 使用 `cy.screenshot()` 捕获测试失败时的截图

## 最佳实践

1. **测试隔离** - 每个测试用例应该是独立的，不依赖其他测试的状态
2. **数据清理** - 在测试完成后清理测试数据
3. **错误处理** - 测试应该能够处理各种错误情况
4. **性能考虑** - 避免不必要的等待时间，使用适当的断言
5. **可读性** - 使用描述性的测试名称和清晰的测试结构
