/// <reference types="cypress" />

describe('布袋周期管理简化测试', () => {
  beforeEach(() => {
    // 模拟登录状态
    cy.mockLogin()
    
    // 导航到布袋周期页面
    cy.navigateToCollectorList()
  })

  it('应该正确显示页面组件', () => {
    // 验证页面组件
    cy.get('[data-testid="collector-list-container"]').should('be.visible')
    cy.get('[data-testid="collector-list-search-form"]').should('be.visible')
    cy.get('[data-testid="collector-table-container"]').should('be.visible')
    cy.get('[data-testid="collector-common-table"]').should('be.visible')
  })

  it('应该验证搜索表单字段', () => {
    // 验证搜索表单字段
    cy.get('[data-testid="collector-compart-input"]').should('be.visible')
    cy.get('[data-testid="collector-duster-name-input"]').should('be.visible')
    cy.get('[data-testid="collector-date-picker"]').should('be.visible')
    cy.get('[data-testid="collector-reset-button"]').should('be.visible')
    cy.get('[data-testid="collector-search-button"]').should('be.visible')
    cy.get('[data-testid="collector-analysis-button"]').should('be.visible')
  })

  it('应该能够进行搜索操作', () => {
    // 使用自定义命令进行搜索
    cy.searchCollectorData('测试仓室', '测试除尘器')
    
    // 验证表格仍然可见
    cy.get('[data-testid="collector-common-table"]').should('be.visible')
  })

  it('应该能够重置搜索条件', () => {
    // 先输入一些搜索条件
    cy.get('[data-testid="collector-compart-input"]').type('测试数据')
    cy.get('[data-testid="collector-duster-name-input"]').type('测试数据')
    
    // 使用自定义命令重置
    cy.resetCollectorSearch()
    
    // 验证表格仍然可见
    cy.get('[data-testid="collector-common-table"]').should('be.visible')
  })

  it('应该能够打开分析对话框', () => {
    // 使用自定义命令打开对话框
    cy.openAnalysisDialog('button')
    
    // 验证对话框内容
    cy.get('.dustListDialog').within(() => {
      cy.get('.input-group').should('be.visible')
      cy.get('.el-select').should('be.visible')
      cy.get('.echartBox').should('be.visible')
    })
    
    // 关闭对话框
    cy.closeAnalysisDialog()
  })

  it('应该能够通过双击除尘器名称打开对话框', () => {
    // 使用自定义命令通过双击打开对话框
    cy.openAnalysisDialog('dblclick')
    
    // 关闭对话框
    cy.closeAnalysisDialog()
  })

  it('应该验证表格列标题', () => {
    // 使用自定义命令验证表格列标题
    cy.verifyCollectorTableHeaders()
  })

  it('应该验证页面响应式设计', () => {
    // 使用现有的响应式检查命令
    cy.checkResponsive()
  })

  it('应该验证除尘器名称链接样式', () => {
    // 验证除尘器名称链接的样式
    cy.get('[data-testid="collector-duster-name-link"]').first().should('have.class', 'health-score')
    cy.get('[data-testid="collector-duster-name-link"]').first().should('have.class', 'green-color')
  })

  it('应该验证页面加载性能', () => {
    // 验证页面加载性能
    cy.window().then((win) => {
      const performance = win.performance
      const navigation = performance.getEntriesByType('navigation')[0]
      
      // 验证页面加载时间在合理范围内
      expect(navigation.loadEventEnd - navigation.loadEventStart).to.be.lessThan(10000)
    })
  })
})
