/// <reference types="cypress" />

describe('我的闭环功能测试', () => {
  beforeEach(() => {
    // 模拟登录状态
    cy.mockLogin()
    
    // 等待登录状态设置完成
    cy.wait(500)
  })

  describe('我的待办页面测试', () => {
    beforeEach(() => {
      // 访问我的待办页面
      cy.visit('/#/my-loop/myAgency')
      
      // 等待页面加载完成
      cy.waitForPageLoad()
    })

    it('应该显示我的待办页面的所有核心组件', () => {
      // 检查主容器
      cy.get('[data-testid="my-agency-container"]').should('be.visible')
      
      // 检查搜索表单
      cy.get('[data-testid="my-agency-search-form"]').should('be.visible')
      cy.get('.demo-form-inline').should('be.visible')
      
      // 检查表格区域
      cy.get('[data-testid="my-agency-table-container"]').should('be.visible')
    })

    it('应该显示所有搜索条件输入框', () => {
      // 检查事件名称输入框
      cy.get('[data-testid="my-agency-event-name-input"]').should('be.visible')
      
      // 检查发生位置输入框
      cy.get('[data-testid="my-agency-keyword-input"]').should('be.visible')
      
      // 检查所属工序选择框
      cy.get('[data-testid="my-agency-production-line-select"]').should('be.visible')
      
      // 检查设备类型选择框
      cy.get('[data-testid="my-agency-device-type-select"]').should('be.visible')
      
      // 检查发生时间选择器
      cy.get('[data-testid="my-agency-date-picker"]').should('be.visible')
    })

    it('应该能够输入搜索条件', () => {
      // 输入事件名称
      cy.get('[data-testid="my-agency-event-name-input"]').clear().type('测试事件')
      cy.get('[data-testid="my-agency-event-name-input"]').should('have.value', '测试事件')
      
      // 输入发生位置
      cy.get('[data-testid="my-agency-keyword-input"]').clear().type('测试位置')
      cy.get('[data-testid="my-agency-keyword-input"]').should('have.value', '测试位置')
    })

    it('应该能够选择所属工序', () => {
      // 点击所属工序选择框
      cy.get('[data-testid="my-agency-production-line-select"]').click()
      
      // 等待下拉选项出现
      cy.get('.el-select-dropdown').should('be.visible')
      
      // 如果有选项，选择第一个
      cy.get('.el-select-dropdown').then(($dropdown) => {
        if ($dropdown.find('.el-select-dropdown__item').length > 0) {
          cy.get('.el-select-dropdown__item').first().click()
        }
      })
    })

    it('应该能够选择设备类型', () => {
      // 点击设备类型选择框
      cy.get('[data-testid="my-agency-device-type-select"]').click()
      
      // 等待下拉选项出现
      cy.get('.el-select-dropdown').should('be.visible')
      
      // 如果有选项，选择第一个
      cy.get('.el-select-dropdown').then(($dropdown) => {
        if ($dropdown.find('.el-select-dropdown__item').length > 0) {
          cy.get('.el-select-dropdown__item').first().click()
        }
      })
    })

    it('应该能够设置发生时间范围', () => {
      // 点击时间选择器
      cy.get('[data-testid="my-agency-date-picker"]').click()
      
      // 等待日期面板出现
      cy.get('.el-picker-panel').should('be.visible')
      
      // 选择开始日期
      cy.get('.el-date-table td.available').first().click()
      
      // 选择结束日期
      cy.get('.el-date-table td.available').eq(5).click()
      
      // 点击确定按钮
      cy.get('.el-picker-panel__footer .el-button--primary').click()
    })

    it('应该能够重置搜索条件', () => {
      // 先输入一些搜索条件
      cy.get('[data-testid="my-agency-event-name-input"]').clear().type('测试事件')
      cy.get('[data-testid="my-agency-keyword-input"]').clear().type('测试位置')
      
      // 点击重置按钮
      cy.get('[data-testid="my-agency-reset-button"]').click()
      
      // 验证输入框已清空
      cy.get('[data-testid="my-agency-event-name-input"]').should('have.value', '')
      cy.get('[data-testid="my-agency-keyword-input"]').should('have.value', '')
    })

    it('应该能够执行搜索查询', () => {
      // 输入搜索条件
      cy.get('[data-testid="my-agency-event-name-input"]').clear().type('测试事件')
      
      // 点击查询按钮
      cy.get('[data-testid="my-agency-search-button"]').click()
      
      // 等待搜索结果加载
      cy.wait(1000)
      
      // 验证页面仍然正常显示
      cy.get('[data-testid="my-agency-table-container"]').should('be.visible')
    })

    it('应该显示待办数据表格', () => {
      // 检查表格容器
      cy.get('[data-testid="my-agency-table-container"]').should('be.visible')
      
      // 检查表格组件
      cy.get('[data-testid="my-agency-common-table"]').should('be.visible')
      
      // 检查表格头部
      cy.get('.el-table__header').should('be.visible')
    })

    it('应该显示表格分页组件', () => {
      // 检查分页组件
      cy.get('.el-pagination').should('be.visible')
      
      // 检查分页信息
      cy.get('.el-pagination__total').should('be.visible')
    })

    it('应该能够进行分页操作', () => {
      // 检查分页按钮
      cy.get('.el-pagination__prev').should('be.visible')
      cy.get('.el-pagination__next').should('be.visible')
      
      // 检查页码按钮
      cy.get('.el-pager').should('be.visible')
    })

    it('应该显示操作按钮', () => {
      // 检查表格行
      cy.get('.el-table__body tr').then(($rows) => {
        if ($rows.length > 0) {
          // 检查处理按钮
          cy.get('[data-testid="my-agency-process-button"]').should('be.visible')
          
          // 检查分派按钮
          cy.get('[data-testid="my-agency-dispatch-button"]').should('be.visible')
        }
      })
    })

    it('应该能够点击处理按钮', () => {
      // 检查表格行
      cy.get('.el-table__body tr').then(($rows) => {
        if ($rows.length > 0) {
          // 点击处理按钮
          cy.get('[data-testid="my-agency-process-button"]').first().click()
          
          // 这里可以添加点击后的验证逻辑
          // 比如检查是否有弹窗、详情页面等
        }
      })
    })

    it('应该能够点击分派按钮', () => {
      // 检查表格行
      cy.get('.el-table__body tr').then(($rows) => {
        if ($rows.length > 0) {
          // 点击分派按钮
          cy.get('[data-testid="my-agency-dispatch-button"]').first().click()
          
          // 这里可以添加点击后的验证逻辑
          // 比如检查是否有弹窗、分派对话框等
        }
      })
    })

    it('应该显示告警级别标识', () => {
      // 检查表格行
      cy.get('.el-table__body tr').then(($rows) => {
        if ($rows.length > 0) {
          // 检查级别列
          cy.get('.el-table__body tr').first().within(() => {
            cy.get('td').should('contain', 'level')
          })
        }
      })
    })

    it('应该处理表格数据加载', () => {
      // 等待表格数据加载
      cy.wait(1000)
      
      // 验证表格仍然可见
      cy.get('[data-testid="my-agency-common-table"]').should('be.visible')
      
      // 验证表格有内容
      cy.get('.el-table__body').should('be.visible')
    })

    it('应该响应搜索条件变化', () => {
      // 输入搜索条件并查询
      cy.get('[data-testid="my-agency-event-name-input"]').clear().type('测试事件')
      cy.get('[data-testid="my-agency-search-button"]').click()
      
      // 等待搜索结果
      cy.wait(1000)
      
      // 验证页面正常显示
      cy.get('[data-testid="my-agency-table-container"]').should('be.visible')
      
      // 清空搜索条件并查询
      cy.get('[data-testid="my-agency-reset-button"]').click()
      cy.get('[data-testid="my-agency-search-button"]').click()
      
      // 等待结果
      cy.wait(1000)
      
      // 验证页面正常显示
      cy.get('[data-testid="my-agency-table-container"]').should('be.visible')
    })

    it('应该检查响应式设计', () => {
      // 检查不同屏幕尺寸下的显示
      const viewports = [
        { width: 1920, height: 1080 }, // 桌面
        { width: 1280, height: 720 },  // 笔记本
        { width: 768, height: 1024 },  // 平板
      ]
      
      viewports.forEach(viewport => {
        cy.viewport(viewport.width, viewport.height)
        cy.wait(500)
        
        // 验证主要组件仍然可见
        cy.get('[data-testid="my-agency-container"]').should('be.visible')
        cy.get('[data-testid="my-agency-search-form"]').should('be.visible')
        cy.get('[data-testid="my-agency-table-container"]').should('be.visible')
      })
    })

    it('应该处理空数据状态', () => {
      // 输入一个不存在的搜索条件
      cy.get('[data-testid="my-agency-event-name-input"]').clear().type('不存在的待办事件')
      cy.get('[data-testid="my-agency-search-button"]').click()
      
      // 等待搜索结果
      cy.wait(1000)
      
      // 验证页面仍然正常显示
      cy.get('[data-testid="my-agency-table-container"]').should('be.visible')
    })

    it('应该验证表格列标题', () => {
      // 检查表格头部
      cy.get('.el-table__header').should('be.visible')
      
      // 检查表格头部行
      cy.get('.el-table__header tr').should('be.visible')
      
      // 检查表格头部单元格
      cy.get('.el-table__header th').should('be.visible')
    })
  })

  describe('我的已办页面测试', () => {
    beforeEach(() => {
      // 访问我的已办页面
      cy.visit('/#/my-loop/myDone')
      
      // 等待页面加载完成
      cy.waitForPageLoad()
    })

    it('应该显示我的已办页面的所有核心组件', () => {
      // 检查主容器
      cy.get('.my-done').should('be.visible')
      
      // 检查搜索表单
      cy.get('.demo-form-inline').should('be.visible')
      
      // 检查表格区域
      cy.get('.table-box').should('be.visible')
    })

    it('应该显示所有搜索条件输入框', () => {
      // 检查事件名称输入框
      cy.get('input[placeholder="请输入事件名称"]').should('be.visible')
      
      // 检查发生位置输入框
      cy.get('input[placeholder="请输入"]').should('be.visible')
      
      // 检查所属工序选择框
      cy.get('.el-select').should('be.visible')
      
      // 检查发生时间选择器
      cy.get('input[placeholder="开始日期"]').should('be.visible')
    })

    it('应该能够输入搜索条件', () => {
      // 输入事件名称
      cy.get('input[placeholder="请输入事件名称"]').clear().type('测试事件')
      cy.get('input[placeholder="请输入事件名称"]').should('have.value', '测试事件')
      
      // 输入发生位置
      cy.get('input[placeholder="请输入"]').clear().type('测试位置')
      cy.get('input[placeholder="请输入"]').should('have.value', '测试位置')
    })

    it('应该能够选择所属工序', () => {
      // 点击所属工序选择框
      cy.get('.el-select').click()
      
      // 等待下拉选项出现
      cy.get('.el-select-dropdown').should('be.visible')
      
      // 如果有选项，选择第一个
      cy.get('.el-select-dropdown').then(($dropdown) => {
        if ($dropdown.find('.el-select-dropdown__item').length > 0) {
          cy.get('.el-select-dropdown__item').first().click()
        }
      })
    })

    it('应该能够设置发生时间范围', () => {
      // 点击时间选择器
      cy.get('input[placeholder="开始日期"]').click()
      
      // 等待日期面板出现
      cy.get('.el-picker-panel').should('be.visible')
      
      // 选择开始日期
      cy.get('.el-date-table td.available').first().click()
      
      // 选择结束日期
      cy.get('.el-date-table td.available').eq(5).click()
      
      // 点击确定按钮
      cy.get('.el-picker-panel__footer .el-button--primary').click()
    })

    it('应该能够重置搜索条件', () => {
      // 先输入一些搜索条件
      cy.get('input[placeholder="请输入事件名称"]').clear().type('测试事件')
      cy.get('input[placeholder="请输入"]').clear().type('测试位置')
      
      // 点击重置按钮
      cy.get('.reset-btn-balck-theme').click()
      
      // 验证输入框已清空
      cy.get('input[placeholder="请输入事件名称"]').should('have.value', '')
      cy.get('input[placeholder="请输入"]').should('have.value', '')
    })

    it('应该能够执行搜索查询', () => {
      // 输入搜索条件
      cy.get('input[placeholder="请输入事件名称"]').clear().type('测试事件')
      
      // 点击查询按钮
      cy.get('.search-btn-balck-theme').click()
      
      // 等待搜索结果加载
      cy.wait(1000)
      
      // 验证页面仍然正常显示
      cy.get('.table-box').should('be.visible')
    })

    it('应该显示已办数据表格', () => {
      // 检查表格容器
      cy.get('.table-box').should('be.visible')
      
      // 检查表格组件
      cy.get('.el-table').should('be.visible')
      
      // 检查表格头部
      cy.get('.el-table__header').should('be.visible')
    })

    it('应该显示表格分页组件', () => {
      // 检查分页组件
      cy.get('.el-pagination').should('be.visible')
      
      // 检查分页信息
      cy.get('.el-pagination__total').should('be.visible')
    })

    it('应该能够进行分页操作', () => {
      // 检查分页按钮
      cy.get('.el-pagination__prev').should('be.visible')
      cy.get('.el-pagination__next').should('be.visible')
      
      // 检查页码按钮
      cy.get('.el-pager').should('be.visible')
    })

    it('应该显示查看按钮', () => {
      // 检查表格行
      cy.get('.el-table__body tr').then(($rows) => {
        if ($rows.length > 0) {
          // 检查查看按钮
          cy.get('.el-table__body tr').first().within(() => {
            cy.get('td').last().should('contain', '查看')
          })
        }
      })
    })

    it('应该能够点击查看按钮', () => {
      // 检查表格行
      cy.get('.el-table__body tr').then(($rows) => {
        if ($rows.length > 0) {
          // 点击查看按钮
          cy.get('.el-table__body tr').first().within(() => {
            cy.get('td').last().contains('查看').click()
          })
          
          // 这里可以添加点击后的验证逻辑
          // 比如检查是否有详情页面等
        }
      })
    })

    it('应该显示告警级别标识', () => {
      // 检查表格行
      cy.get('.el-table__body tr').then(($rows) => {
        if ($rows.length > 0) {
          // 检查级别列
          cy.get('.el-table__body tr').first().within(() => {
            cy.get('td').should('contain', 'level')
          })
        }
      })
    })

    it('应该处理表格数据加载', () => {
      // 等待表格数据加载
      cy.wait(1000)
      
      // 验证表格仍然可见
      cy.get('.el-table').should('be.visible')
      
      // 验证表格有内容
      cy.get('.el-table__body').should('be.visible')
    })

    it('应该响应搜索条件变化', () => {
      // 输入搜索条件并查询
      cy.get('input[placeholder="请输入事件名称"]').clear().type('测试事件')
      cy.get('.search-btn-balck-theme').click()
      
      // 等待搜索结果
      cy.wait(1000)
      
      // 验证页面正常显示
      cy.get('.table-box').should('be.visible')
      
      // 清空搜索条件并查询
      cy.get('.reset-btn-balck-theme').click()
      cy.get('.search-btn-balck-theme').click()
      
      // 等待结果
      cy.wait(1000)
      
      // 验证页面正常显示
      cy.get('.table-box').should('be.visible')
    })

    it('应该检查响应式设计', () => {
      // 检查不同屏幕尺寸下的显示
      const viewports = [
        { width: 1920, height: 1080 }, // 桌面
        { width: 1280, height: 720 },  // 笔记本
        { width: 768, height: 1024 },  // 平板
      ]
      
      viewports.forEach(viewport => {
        cy.viewport(viewport.width, viewport.height)
        cy.wait(500)
        
        // 验证主要组件仍然可见
        cy.get('.my-done').should('be.visible')
        cy.get('.demo-form-inline').should('be.visible')
        cy.get('.table-box').should('be.visible')
      })
    })

    it('应该处理空数据状态', () => {
      // 输入一个不存在的搜索条件
      cy.get('input[placeholder="请输入事件名称"]').clear().type('不存在的已办事件')
      cy.get('.search-btn-balck-theme').click()
      
      // 等待搜索结果
      cy.wait(1000)
      
      // 验证页面仍然正常显示
      cy.get('.table-box').should('be.visible')
    })

    it('应该验证表格列标题', () => {
      // 检查表格头部
      cy.get('.el-table__header').should('be.visible')
      
      // 检查表格头部行
      cy.get('.el-table__header tr').should('be.visible')
      
      // 检查表格头部单元格
      cy.get('.el-table__header th').should('be.visible')
    })
  })
})
