import request from "./index.js";
import qs from "qs";

export function getData(url, pri) {
  return request({
    url,
    method: "get"
  });
}
export function getVisData(url) {
  return request({
    url,
    method: "get"
  });
}

export function http(method, url, data) {
  return request({
    url: url,
    method,
    data
    // headers: {
    //   'Content-Type': 'application/json'
    // }
  });
}

export function getDataFun(url, params) {
  return request({
    url,
    method: "get",
    params
  });
}

export function postDataJSON(url, data) {
  /*url.indexOf('admin') > -1 ? url = process.env.VUE_APP_BASE_API4 + url
    : url = process.env.VUE_APP_BASE_API1 + url*/
  return request({
    url: url,
    method: "post",
    data: data,
    headers: {
      "Content-Type": "application/json"
    }
  });
}

export function postData(url, data) {
  console.log(data);
  // url.indexOf('admin') > -1 ? url = process.env.VUE_APP_BASE_API4 + url
  //   : url = process.env.VUE_APP_BASE_API1 + url
  return request({
    url: url,
    method: "POST",
    params: data
  });
}

export function postDataFun(url, data) {
  console.log(data);
  // url.indexOf('admin') > -1 ? url = process.env.VUE_APP_BASE_API4 + url
  //   : url = process.env.VUE_APP_BASE_API1 + url
  return request({
    url: url,
    method: "POST",
    params: data,
    headers: {
      "content-type": "application/x-www-form-urlencoded"
    }
  });
}

export function putData(url, data) {
  return request({
    url: url,
    method: "PUT",
    params: data
  });
}

export function deleteData(url, data) {
  return request({
    url: url,
    method: "delete",
    params: data
  });
}

export function postDataJson(url, data) {
  return request({
    url: url,
    method: "post",
    data,
    headers: {
      "Content-Type": "application/json"
    }
  });
}

export function uploadFiles(method, url, data) {
  return request({
    url: url,
    method,
    data,
    headers: {
      "Content-Type": "multipart/form-data"
    }
  });
}

export function getDataScreen(url, params) {
  return request({
    url,
    method: "get",
    params
  });
}

export function postDataScreen(url, data) {
  return request({
    url: url,
    method: "post",
    data: qs.stringify(data)
  });
}

export function exportFile(method, url, data) {
  return request({
    url: url,
    method,
    data,
    headers: {
      "Content-Type": "multipart/form-data"
    },
    responseType: 'blob'
  });
}

// 百度坐标转高德（传入经度、纬度）
export function bd_decrypt(bd_lng, bd_lat) {
  var X_PI = (Math.PI * 3000.0) / 180.0;
  var x = bd_lng - 0.0065;
  var y = bd_lat - 0.006;
  var z = Math.sqrt(x * x + y * y) - 0.00002 * Math.sin(y * X_PI);
  var theta = Math.atan2(y, x) - 0.000003 * Math.cos(x * X_PI);
  var gg_lng = z * Math.cos(theta);
  var gg_lat = z * Math.sin(theta);
  return { lng: gg_lng, lat: gg_lat };
}

// 高德坐标转百度（传入经度、纬度）
export function bd_encrypt(gg_lng, gg_lat) {
  var X_PI = (Math.PI * 3000.0) / 180.0;
  var x = gg_lng;
  var y = gg_lat;
  var z = Math.sqrt(x * x + y * y) + 0.00002 * Math.sin(y * X_PI);
  var theta = Math.atan2(y, x) + 0.000003 * Math.cos(x * X_PI);
  var bd_lng = z * Math.cos(theta) + 0.0065;
  var bd_lat = z * Math.sin(theta) + 0.006;
  return {
    bd_lat: bd_lat,
    bd_lng: bd_lng
  };
}

function transformlat(lng, lat) {
  const PI = 3.1415926535897932384626;
  let ret =
    -100.0 +
    2.0 * lng +
    3.0 * lat +
    0.2 * lat * lat +
    0.1 * lng * lat +
    0.2 * Math.sqrt(Math.abs(lng));
  ret +=
    ((20.0 * Math.sin(6.0 * lng * PI) + 20.0 * Math.sin(2.0 * lng * PI)) *
      2.0) /
    3.0;
  ret +=
    ((20.0 * Math.sin(lat * PI) + 40.0 * Math.sin((lat / 3.0) * PI)) * 2.0) /
    3.0;
  ret +=
    ((160.0 * Math.sin((lat / 12.0) * PI) + 320 * Math.sin((lat * PI) / 30.0)) *
      2.0) /
    3.0;
  return ret;
}
function transformlng(lng, lat) {
  const PI = 3.1415926535897932384626;
  let ret =
    300.0 +
    lng +
    2.0 * lat +
    0.1 * lng * lng +
    0.1 * lng * lat +
    0.1 * Math.sqrt(Math.abs(lng));
  ret +=
    ((20.0 * Math.sin(6.0 * lng * PI) + 20.0 * Math.sin(2.0 * lng * PI)) *
      2.0) /
    3.0;
  ret +=
    ((20.0 * Math.sin(lng * PI) + 40.0 * Math.sin((lng / 3.0) * PI)) * 2.0) /
    3.0;
  ret +=
    ((150.0 * Math.sin((lng / 12.0) * PI) +
      300.0 * Math.sin((lng / 30.0) * PI)) *
      2.0) /
    3.0;
  return ret;
}

//WSG84转BD09
export function wgs84togcj02tobd09(lng, lat) {
  const xPI = (3.14159265358979324 * 3000.0) / 180.0;
  const PI = 3.1415926535897932384626;
  const a = 6378245.0;
  const ee = 0.00669342162296594323;
  // WGS84转GCj02
  let dlat = transformlat(lng - 105.0, lat - 35.0);
  let dlng = transformlng(lng - 105.0, lat - 35.0);
  let radlat = (lat / 180.0) * PI;
  let magic = Math.sin(radlat);
  magic = 1 - ee * magic * magic;
  let sqrtmagic = Math.sqrt(magic);
  dlat = (dlat * 180.0) / (((a * (1 - ee)) / (magic * sqrtmagic)) * PI);
  dlng = (dlng * 180.0) / ((a / sqrtmagic) * Math.cos(radlat) * PI);
  let mglat = lat + dlat;
  let mglng = lng + dlng;
  // 火星坐标系 (GCJ-02) 与百度坐标系 (BD-09) 的转换
  let z =
    Math.sqrt(mglng * mglng + mglat * mglat) + 0.00002 * Math.sin(mglat * xPI);
  let theta = Math.atan2(mglat, mglng) + 0.000003 * Math.cos(mglng * xPI);
  let bdlng = z * Math.cos(theta) + 0.0065;
  let bdlat = z * Math.sin(theta) + 0.006;
  // return [bdlng, bdlat]
  return { bd_lng: bdlng, bd_lat: bdlat };
}

export function dateFormat(fmt, date) {
  let ret;
  if (date) {
    const time = new Date(date);
    const opt = {
      "Y+": time.getFullYear().toString(),
      "m+": (time.getMonth() + 1).toString(),
      "d+": time.getDate().toString(),
      "H+": time.getHours().toString(),
      "M+": time.getMinutes().toString(),
      "S+": time.getSeconds().toString()
    };

    for (const k in opt) {
      ret = new RegExp("(" + k + ")").exec(fmt);
      if (ret) {
        fmt = fmt.replace(
          ret[1],
          ret[1].length == 1 ? opt[k] : opt[k].padStart(ret[1].length, "0")
        );
      }
    }
    return fmt;
  }
}
