// cypress/support/component.js
// 组件测试支持文件

import { mount } from 'cypress/vue'
import { createPinia } from 'pinia'
import ElementPlus from 'element-plus'
import 'element-plus/dist/index.css'

// 注册mount命令
Cypress.Commands.add('mount', (component, options = {}) => {
  options.global = options.global || {}
  options.global.plugins = options.global.plugins || []
  
  // 添加Pinia和ElementPlus
  options.global.plugins.push(createPinia())
  options.global.plugins.push(ElementPlus)
  
  return mount(component, options)
})