import { color } from "echarts";

export const getLineOption = (xData = [], seriesData = []) => ({
    tooltip: {
      trigger: 'axis',
    },
    grid: {
      left: '3%',
      right: '4%',
      bottom: '15%',
      top: '5%',
      containLabel: true,
    },
    legend: {
      data: ['健康度指数（%）'],
      bottom: '0%',
      icon:"circle",
      itemWidth: 10,
      itemHeight: 10,
      itemGap: 10,
    },
    xAxis: {
      type: 'category',
      axisTick: {
        show: false,
      },
      axisLine: {
        lineStyle: {
          color: '#E9ECF2',
        },
      },
      axisLabel: {
        color: 'rgba(0,0,0,0.6)',
      },
      data: xData,

    },
    yAxis: {
      type: 'value',
      axisLabel: {
        color: 'rgba(0,0,0,0.6)',
      },
      splitLine: {
        lineStyle: {
          color: '#E9ECF2',
          type: 'dashed',
        },
      },

    },
    series: [
      {
        name: '健康度指数（%）',
        type: 'line',
        color: '#399DFA',
        data: seriesData,
        smooth: true,
      },
    ],
  });