import request from "./index.js";

export function login(data) {
  return request({
    url: '/user/login',
    method: 'post',
    data
  })
}

export function captchaLoginFun(data) {
  return request({
    url: '/user/captchaLogin',
    method: 'post',
    data
  })
}

export function getLogin() {
  return request({
    url: '/login',
    method: 'get'
  })
}

export function getInfo() {
  return request({
    url: '/system/permission?appCode=bme-pc-service&userId=1',
    method: 'get'
  })
}

export function findPcMenu(customerId) {
  return request({
    url:'/modelConfigController/findPcMenu?customerId=' + customerId,
    method: 'get'
  })
}

export function getWeather(customerId) {
  return request({
    url:'/system/weather?customerId=' + customerId,
    method: 'get'
  })
}

export function getFunctionList(customerId) {
  return request({
    url:'/system/function/listAllEnable?customerId=' + customerId + "&isEnable=" + true,
    method: 'get'
  })
}

export function logout() {
  return request({
    url:'/user/logout',
    method: 'post'
  })
}

export function upload(url, data) {
  url.indexOf('admin') > -1 ? url = process.env.VUE_APP_BASE_API4 + url
    : url = process.env.VUE_APP_BASE_API1 + url
  return request({
    url: url,
    method: 'post',
    data: data
  })
}

export function exportFlie(url, data) {
  url.indexOf('admin') > -1 ? url = process.env.VUE_APP_BASE_API4 + url
    : url = process.env.VUE_APP_BASE_API1 + url
  return request({
    url: url,
    headers: {
      responseType: 'blob'
    },
    method: 'post',
    data: data
  })
}

