# Cypress 独立测试工具

一个独立的 Cypress 端到端测试工具，可用于测试任何前端应用程序。

## 🚀 快速开始

### 安装依赖
```bash
npm install
```

## 🧪 测试

### Cypress 端到端测试
```bash
# 打开 Cypress 测试界面
npm run cy:open

# 运行所有测试
npm run cy:run

# 运行特定环境的测试
npm run cy:run:dev     # 开发环境测试
npm run cy:run:staging # 预发布环境测试
npm run cy:run:prod    # 生产环境测试
npm run cy:run:custom  # 自定义环境测试

# 使用特定浏览器运行测试
npm run cy:run:chrome  # Chrome浏览器
npm run cy:run:firefox # Firefox浏览器
```

### 批量测试
```bash
# 运行所有环境的测试
npm run test:all
```

## 🔧 配置

### 环境配置文件

项目包含多个环境配置文件：
- `.env.development` - 开发环境配置
- `.env.staging` - 预发布环境配置
- `.env.production` - 生产环境配置
- `.env.custom` - 自定义环境配置（可随时修改用于测试不同地址）

### 环境变量

支持以下环境变量：
- `CYPRESS_BASE_URL` - 测试目标的基础URL
- `CYPRESS_API_URL` - API接口的基础URL
- `CYPRESS_USERNAME` - 测试用户名
- `CYPRESS_PASSWORD` - 测试密码
- `CYPRESS_REPORT_TITLE` - 测试报告标题
- `CYPRESS_REPORT_PAGE_TITLE` - 测试报告页面标题

### 脚本执行

也可以使用脚本执行测试：
```bash
# 使用脚本执行测试
./run-tests.sh [environment] [browser]

# 示例
./run-tests.sh staging chrome
./run-tests.sh custom chrome
./run-tests.sh https://your-website.com chrome  # 直接指定URL
```

## 📁 项目结构

```
cypress/
├── e2e/           # 端到端测试用例
├── support/       # 测试支持文件
│   └── page-objects/ # 页面对象模型
└── fixtures/      # 测试数据

.env.development   # 开发环境配置
.env.staging       # 预发布环境配置
.env.production    # 生产环境配置
.env.custom        # 自定义环境配置
run-tests.sh       # 测试执行脚本
```

## 🛠️ 技术栈

- **测试框架**: Cypress 13.6+
- **报告生成**: Mochawesome

## 📖 使用指南

### 1. 配置测试目标

修改 `.env.development` 文件中的 `CYPRESS_BASE_URL` 为您的开发环境地址。

要测试不同的地址，您可以：
- 修改现有的环境配置文件
- 创建新的环境配置文件
- 直接在运行脚本时指定URL

### 2. 编写测试用例

在 `cypress/e2e/` 目录下创建测试文件，文件名以 `.cy.js` 结尾。

### 3. 运行测试

使用 npm 脚本或直接运行 Cypress 命令执行测试。

### 4. 查看报告

测试执行完成后，报告将生成在 `cypress/reports/` 目录中。

## 🔗 相关链接

- [Cypress 文档](https://docs.cypress.io/)