import { defineConfig } from 'cypress'

export default defineConfig({
  e2e: {
    // 通过环境变量设置基础URL
    baseUrl: process.env.CYPRESS_BASE_URL || 'http://localhost:3000',
    viewportWidth: 1280,
    viewportHeight: 720,
    video: true,
    screenshotOnRunFailure: true,
    videosFolder: 'cypress/videos',
    screenshotsFolder: 'cypress/screenshots',
    defaultCommandTimeout: 15000,
    requestTimeout: 15000,
    responseTimeout: 15000,
    pageLoadTimeout: 30000,
    experimentalStudio: true,
    experimentalInteractiveRunEvents: true,
    chromeWebSecurity: false,
    modifyObstructiveCode: false,
    retries: {
      runMode: 2,
      openMode: 0
    },
    setupNodeEvents(on, config) {
      // 根据环境变量动态设置配置
      if (config.isTextTerminal) {
        config.video = true
        config.screenshotOnRunFailure = true
      }
      return config
    },
    env: {
      // 支持多环境配置
      apiUrl: process.env.CYPRESS_API_URL || process.env.CYPRESS_BASE_URL || 'http://localhost:3000',
      username: process.env.CYPRESS_USERNAME || 'test@example.com',
      password: process.env.CYPRESS_PASSWORD || 'testpassword'
    },
    specPattern: 'cypress/e2e/**/*.cy.{js,jsx,ts,tsx}',
    supportFile: 'cypress/support/e2e.js',
    reporter: 'mochawesome',
    reporterOptions: {
      reportDir: 'cypress/reports',
      overwrite: false,
      html: true,
      json: true,
      timestamp: 'mmddyyyy_HHMMss',
      reportTitle: process.env.CYPRESS_REPORT_TITLE || 'Cypress Tests',
      reportPageTitle: process.env.CYPRESS_REPORT_PAGE_TITLE || '测试报告'
    }
  },
  component: {
    devServer: {
      framework: 'vue',
      bundler: 'vite',
    },
    specPattern: 'src/**/*.cy.{js,jsx,ts,tsx,vue}',
    supportFile: 'cypress/support/component.js'
  }
})