// cypress/support/page-objects/loginPage.js
class LoginPage {
  get usernameInput() { return cy.get('[data-testid="login-username-input"]') }
  get passwordInput() { return cy.get('[data-testid="login-password-input"]') }
  get captchaInput() { return cy.get('[data-testid="login-captcha-input"]') }
  get submitButton() { return cy.get('[data-testid="login-submit-button"]') }

  login(username, password) {
    this.usernameInput.type(username)
    this.passwordInput.type(password)
    this.captchaInput.type('8888')
    this.submitButton.click()
  }
}

export default new LoginPage()