#!/bin/bash

# 通用测试执行脚本
# 用法: ./run-tests.sh [environment] [browser]
# 示例: ./run-tests.sh staging chrome

ENV=${1:-development}
BROWSER=${2:-chrome}

echo "开始执行 $ENV 环境的测试，使用 $BROWSER 浏览器"

# 根据环境设置变量
case $ENV in
  "development"|"dev")
    export CYPRESS_BASE_URL="http://localhost:3000"
    export CYPRESS_REPORT_TITLE="Development Tests"
    ;;
  "staging")
    export CYPRESS_BASE_URL="https://staging.example.com"
    export CYPRESS_REPORT_TITLE="Staging Tests"
    ;;
  "production"|"prod")
    export CYPRESS_BASE_URL="https://app.example.com"
    export CYPRESS_REPORT_TITLE="Production Tests"
    ;;
  "custom")
    # 加载自定义环境变量
    if [ -f ".env.custom" ]; then
      source .env.custom
      echo "已加载自定义环境配置"
    else
      echo "警告: 未找到 .env.custom 文件"
    fi
    ;;
  *)
    # 支持直接指定URL
    if [[ $ENV == http* ]]; then
      export CYPRESS_BASE_URL=$ENV
      export CYPRESS_REPORT_TITLE="Custom URL Tests"
      echo "使用自定义URL: $ENV"
    else
      echo "未知环境: $ENV"
      echo "支持的环境: development, staging, production, custom"
      echo "或者直接指定URL，例如: ./run-tests.sh https://your-site.com chrome"
      exit 1
    fi
    ;;
esac

# 执行测试
npx cypress run --browser $BROWSER

echo "测试执行完成"